/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.util.ParseTools;
import java.util.concurrent.ConcurrentHashMap;

public final class CommunicatorFactory {
    private static final CommunicatorFactory instance = new CommunicatorFactory();
    private volatile ConcurrentHashMap<Object, Communicator> CommunicatorMap = new ConcurrentHashMap();
    private volatile Communicator communicator = null;

    public static CommunicatorFactory getInstance() {
        return instance;
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    void setCommunicator(Communicator communicator) {
        if (communicator != null) {
            this.communicator = communicator;
        }
    }

    public Communicator getCommunicator(String locator) {
        Communicator communicator = this.CommunicatorMap.get(locator);
        if (communicator != null) {
            return communicator;
        }
        CommunicatorConfig config = null;
        if (ParseTools.hasServerNode(locator)) {
            config = new CommunicatorConfig();
            config.setLocator(locator);
        }
        this.CommunicatorMap.putIfAbsent(locator, new Communicator(config));
        return this.CommunicatorMap.get(locator);
    }

    public Communicator getCommunicator(CommunicatorConfig config) {
        Communicator communicator = this.CommunicatorMap.get(config);
        if (communicator != null) {
            return communicator;
        }
        this.CommunicatorMap.putIfAbsent(config, new Communicator(config));
        return this.CommunicatorMap.get(config);
    }
}

