/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.support;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.rpc.ServantClient;
import com.qq.tars.common.util.concurrent.TaskQueue;
import com.qq.tars.common.util.concurrent.TaskThreadFactory;
import com.qq.tars.common.util.concurrent.TaskThreadPoolExecutor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.protocol.ProtocolFactory;
import com.qq.tars.support.log.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ClientPoolManager {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private static final ConcurrentHashMap<CommunicatorConfig, ThreadPoolExecutor> clientThreadPoolMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServantProxyConfig, SelectorManager> selectorsMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getClientThreadPoolExecutor(CommunicatorConfig communicatorConfig) {
        ThreadPoolExecutor clientPoolExecutor = clientThreadPoolMap.get(communicatorConfig);
        if (clientPoolExecutor != null) return clientPoolExecutor;
        Class<ServantClient> clazz = ServantClient.class;
        synchronized (ServantClient.class) {
            clientPoolExecutor = clientThreadPoolMap.get(communicatorConfig);
            if (clientPoolExecutor != null) return clientPoolExecutor;
            clientThreadPoolMap.put(communicatorConfig, ClientPoolManager.createThreadPool(communicatorConfig));
            return clientThreadPoolMap.get(communicatorConfig);
        }
    }

    private static ThreadPoolExecutor createThreadPool(CommunicatorConfig communicatorConfig) {
        int corePoolSize = communicatorConfig.getCorePoolSize();
        int maxPoolSize = communicatorConfig.getMaxPoolSize();
        int keepAliveTime = communicatorConfig.getKeepAliveTime();
        int queueSize = communicatorConfig.getQueueSize();
        TaskQueue taskqueue = new TaskQueue(queueSize);
        String namePrefix = "tars-client-executor-";
        logger.info("create client thread pool, communicator config is {}", (Object)communicatorConfig.toString());
        TaskThreadPoolExecutor executor = new TaskThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, new TaskThreadFactory(namePrefix));
        taskqueue.setParent(executor);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorManager getSelectorManager(ProtocolFactory protocolFactory, ThreadPoolExecutor threadPoolExecutor, boolean keepAlive, boolean udpMode, ServantProxyConfig servantProxyConfig) throws IOException {
        SelectorManager selector = selectorsMap.get(servantProxyConfig);
        if (selector == null) {
            ConcurrentHashMap<ServantProxyConfig, SelectorManager> concurrentHashMap = selectorsMap;
            synchronized (concurrentHashMap) {
                selector = selectorsMap.get(servantProxyConfig);
                if (selector == null) {
                    int selectorPoolSize = ClientPoolManager.convertInt(System.getProperty("com.qq.tars.net.client.selectorPoolSize"), 2);
                    selector = new SelectorManager(selectorPoolSize, protocolFactory, (Executor)threadPoolExecutor, null, keepAlive, "servant-proxy-" + servantProxyConfig.getCommunicatorId(), udpMode);
                    selector.start();
                    selectorsMap.put(servantProxyConfig, selector);
                }
            }
        }
        return selector;
    }

    private static int convertInt(String value, int defaults) {
        if (value == null) {
            return defaults;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaults;
        }
    }
}

