/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.protocol.tars.support;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.rpc.tars.TarsInvoker;
import com.qq.tars.net.client.Callback;
import com.qq.tars.rpc.exc.ServerException;
import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class TarsPromiseFutureCallback<V>
implements Callback<TarsServantResponse> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final String objName;
    private final String methodName;
    private final String remoteIp;
    private final int remotePort;
    private final long bornTime;
    private final TarsInvoker<?> invoker;
    private final ServantProxyConfig config;
    private final CompletableFuture<V> completableFuture;

    public TarsPromiseFutureCallback(ServantProxyConfig config, String methodName, String remoteIp, int remotePort, long bornTime, TarsInvoker<?> invoker, CompletableFuture<V> completableFuture) {
        this.config = config;
        this.objName = config.getSimpleObjectName();
        this.methodName = methodName;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.bornTime = bornTime;
        this.invoker = invoker;
        this.completableFuture = completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted(TarsServantResponse response) {
        int ret = 0;
        try {
            if (response.getCause() != null) {
                throw new TarsException(response.getCause());
            }
            if (response.getRet() != 0) {
                throw ServerException.makeException(response.getRet(), response.getRemark());
            }
            this.completableFuture.complete(response.getResult());
        }
        catch (Throwable ex) {
            ret = 1;
            logger.error("error occurred on callback completed", ex);
            this.onException(ex);
        }
        finally {
            this.invoker.setAvailable(ServantInvokerAliveChecker.isAlive(this.invoker.getUrl(), this.config, ret));
            InvokeStatHelper.getInstance().addProxyStat(this.objName).addInvokeTimeByClient(this.config.getMasterName(), this.config.getSlaveName(), this.config.getSlaveSetName(), this.config.getSlaveSetArea(), this.config.getSlaveSetID(), this.methodName, this.remoteIp, this.remotePort, ret, System.currentTimeMillis() - this.bornTime);
        }
    }

    public void onException(Throwable e) {
        try {
            this.completableFuture.completeExceptionally(e);
        }
        catch (Throwable ex) {
            logger.error("error occurred on callback exception", ex);
        }
    }

    public void onExpired() {
        int ret = 2;
        try {
            this.completableFuture.completeExceptionally(ServerException.makeException(ret));
        }
        finally {
            this.invoker.setAvailable(ServantInvokerAliveChecker.isAlive(this.invoker.getUrl(), this.config, ret));
            InvokeStatHelper.getInstance().addProxyStat(this.objName).addInvokeTimeByClient(this.config.getMasterName(), this.config.getSlaveName(), this.config.getSlaveSetName(), this.config.getSlaveSetArea(), this.config.getSlaveSetID(), this.methodName, this.remoteIp, this.remotePort, ret, System.currentTimeMillis() - this.bornTime);
        }
    }
}

