/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.common;

import com.qq.tars.common.util.StringUtils;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigElement {
    private Element e;

    XMLConfigElement(Element e) {
        this.e = e;
    }

    public boolean isValid() {
        return this.e != null;
    }

    public String getStringAttribute(String name) {
        return this.e != null ? this.e.getAttribute(name) : null;
    }

    public String getStringAttribute(String name, String def) {
        String s = this.getStringAttribute(name);
        return s != null && s.length() > 0 ? s : def;
    }

    public boolean isExistAttribute(String name) {
        return this.getStringAttribute(name) != null;
    }

    public boolean getBooleanAttribute(String name, boolean def) {
        String s = this.getStringAttribute(name);
        if ("true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s)) {
            return false;
        }
        return StringUtils.convertBoolean(s, def);
    }

    public int getIntAttribute(String name, int def) {
        String s = this.getStringAttribute(name);
        return StringUtils.convertInt(s, def);
    }

    public double getDoubleAttribute(String name, double def) {
        String s = this.getStringAttribute(name);
        return StringUtils.convertDouble(s, def);
    }

    public long getLongAttribute(String name, long def) {
        String s = this.getStringAttribute(name);
        return StringUtils.convertLong(s, def);
    }

    public short getShortAttribute(String name, short def) {
        String s = this.getStringAttribute(name);
        return StringUtils.convertShort(s, def);
    }

    public float getFloatAttribute(String name, float def) {
        String s = this.getStringAttribute(name);
        return StringUtils.convertFloat(s, def);
    }

    public String getName() {
        return this.e != null ? this.e.getNodeName() : null;
    }

    public String getContent() {
        return this.e != null ? this.e.getTextContent() : null;
    }

    public XMLConfigElement getChildByName(String name) {
        if (this.e == null) {
            return this;
        }
        NodeList nl = this.e.getElementsByTagName(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Element ee = (Element)n;
            if (ee == null) continue;
            return new XMLConfigElement(ee);
        }
        return new XMLConfigElement(null);
    }

    public ArrayList<XMLConfigElement> getChildListByName(String name) {
        ArrayList<XMLConfigElement> list = new ArrayList<XMLConfigElement>();
        if (this.e == null) {
            return list;
        }
        NodeList nl = this.e.getElementsByTagName(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Element ee = (Element)n;
            if (ee == null) continue;
            list.add(new XMLConfigElement(ee));
        }
        return list;
    }

    public ArrayList<XMLConfigElement> getChildList() {
        ArrayList<XMLConfigElement> list = new ArrayList<XMLConfigElement>();
        if (this.e == null) {
            return list;
        }
        NodeList nl = this.e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element ee = (Element)n;
            list.add(new XMLConfigElement(ee));
        }
        return list;
    }
}

