/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.config;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.common.util.Config;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.server.config.ConfigurationException;
import com.qq.tars.server.config.ServerConfig;
import java.io.IOException;

public class ConfigurationManager {
    private static final ConfigurationManager instance = new ConfigurationManager();
    private volatile ServerConfig serverConfig;
    private volatile CommunicatorConfig communicatorConfig;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig config) {
        this.serverConfig = config;
    }

    public CommunicatorConfig getCommunicatorConfig() {
        return this.communicatorConfig;
    }

    public void setCommunicatorConfig(CommunicatorConfig communicatorConfig) {
        this.communicatorConfig = communicatorConfig;
    }

    public void init() throws ConfigurationException {
        this.loadServerConfig();
    }

    private void loadServerConfig() throws ConfigurationException {
        String key = null;
        String value = null;
        try {
            ServerConfig cfg = new ServerConfig().load(Config.parseFile(System.getProperty("config")));
            key = "app";
            value = cfg.getApplication();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "server";
            value = cfg.getServerName();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "localip";
            value = cfg.getLocalIP();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "local";
            String string = value = cfg.getLocal() == null ? null : cfg.getLocal().toString();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "logpath";
            value = cfg.getLogPath();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "logLevel";
            value = cfg.getLogLevel();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            key = "datapath";
            value = cfg.getDataPath();
            if (StringUtils.isEmpty(value)) {
                throw new ConfigurationException("invalid config");
            }
            this.serverConfig = cfg;
            this.communicatorConfig = cfg.getCommunicatorConfig();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("read config file error.", ioe);
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw new ConfigurationException("contains invalid config|key=" + key + ", value=" + value, e);
            }
            throw new ConfigurationException("error occurred on load server config", e);
        }
    }
}

