/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.net.core.Processor;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.rpc.protocol.ext.ExtendedServantRequest;
import com.qq.tars.rpc.protocol.ext.ExtendedServantResponse;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.server.core.Context;
import com.qq.tars.server.core.ContextManager;
import com.qq.tars.server.core.ServantAdapter;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.support.om.OmServiceMngr;
import java.lang.reflect.Method;

public abstract class ExtendedServantProcessor<RES extends ExtendedServantRequest, RESP extends ExtendedServantResponse>
extends Processor {
    private final ServantAdapter servantAdapter;

    public ExtendedServantProcessor(ServantAdapter servantAdapter) {
        this.servantAdapter = servantAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response process(Request req, Session session) {
        ExtendedServantRequest request = null;
        ExtendedServantResponse response = null;
        ServantHomeSkeleton skeleton = null;
        AppContext appContext = null;
        ClassLoader oldClassLoader = null;
        int waitingTime = -1;
        long startTime = req.getProcessTime();
        try {
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            request = (ExtendedServantRequest)req;
            response = (ExtendedServantResponse)this.createResponse(request, session);
            response.setTicketNumber(req.getTicketNumber());
            String servantName = this.servantAdapter.getServantAdapterConfig().getServant();
            request.setServantName(this.servantAdapter.getServantAdapterConfig().getServant());
            int maxWaitingTimeInQueue = ConfigurationManager.getInstance().getServerConfig().getServantAdapterConfMap().get(servantName).getQueueTimeout();
            waitingTime = (int)(startTime - req.getBornTime());
            if (waitingTime > maxWaitingTimeInQueue) {
                throw new TarsException("Wait too long, server busy.");
            }
            appContext = AppContextManager.getInstance().getAppContext();
            if (appContext == null) {
                throw new RuntimeException("failed to find the application named:[ROOT]");
            }
            Context<ExtendedServantRequest, ExtendedServantResponse> context = ContextManager.registerContext(request, response);
            context.setAttribute("internal.startTime", startTime);
            context.setAttribute("internal.requestIp", session.getRemoteIp());
            context.setAttribute("internal.requestApp", appContext.name());
            context.setAttribute("internal.requestService", request.getServantName());
            context.setAttribute("internal.requestMethod", request.getFunctionName());
            context.setAttribute("internal.sessionData", session);
            skeleton = this.servantAdapter.getSkeleton();
            if (skeleton == null) {
                throw new RuntimeException("failed to find the servant named[" + servantName + "]");
            }
            Method method = skeleton.getApiClass().getMethods()[0];
            skeleton.invoke(method, request, response);
        }
        catch (Throwable cause) {
            if (cause instanceof TarsException) {
                System.out.println("ERROR: " + cause.getMessage());
            } else {
                cause.printStackTrace();
            }
            response.setThrowable(cause);
        }
        finally {
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            ContextManager.releaseContext();
            OmServiceMngr.getInstance().reportWaitingTimeProperty(waitingTime);
        }
        return response;
    }

    protected abstract RESP createResponse(RES var1, Session var2);
}

