/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.common.Filter;
import com.qq.tars.common.FilterKind;
import com.qq.tars.common.support.Endpoint;
import com.qq.tars.common.util.DyeingKeyCache;
import com.qq.tars.common.util.DyeingSwitch;
import com.qq.tars.context.DistributedContext;
import com.qq.tars.context.DistributedContextManager;
import com.qq.tars.net.core.Processor;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.rpc.exc.ServerDecodeException;
import com.qq.tars.rpc.exc.ServerException;
import com.qq.tars.rpc.exc.ServerNoServantException;
import com.qq.tars.rpc.exc.ServerOverloadException;
import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.server.core.AsyncContext;
import com.qq.tars.server.core.Context;
import com.qq.tars.server.core.ContextManager;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.server.core.TarsServerFilterChain;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.om.OmServiceMngr;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;

public class TarsServantProcessor
extends Processor {
    private static final String FLOW_SEP_FLAG = "|";
    private static final Random rand = new Random(System.currentTimeMillis());
    private static final Logger flowLogger = LoggerFactory.getLogger("tarsserver");

    public static void printServiceFlowLog(Logger logger, TarsServantRequest request, int status, long cost, String remark) {
        if (status == 0 && !TarsServantProcessor.isFlowLogEnable()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Object[] args = request.getMethodParameters();
        int len = 25;
        sb.append(FLOW_SEP_FLAG);
        sb.append(request.getIoSession().getRemoteIp()).append(FLOW_SEP_FLAG);
        sb.append(request.getFunctionName()).append(FLOW_SEP_FLAG);
        if (null != args) {
            StringBuilder sbArgs = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    sbArgs.append("NULL").append(",");
                    continue;
                }
                if (args[i] instanceof Number || args[i] instanceof Boolean) {
                    sbArgs.append(args[i]).append(",");
                    continue;
                }
                sbArgs.append(TarsServantProcessor.encodeStringParam(args[i].toString(), len)).append(",");
            }
            sbArgs = sbArgs.length() >= 1 ? sbArgs.deleteCharAt(sbArgs.length() - 1) : sbArgs;
            sb.append((CharSequence)sbArgs);
        }
        sb.append(FLOW_SEP_FLAG);
        sb.append(status).append(FLOW_SEP_FLAG).append(cost);
        sb.append(FLOW_SEP_FLAG).append(remark);
        logger.info(sb.toString());
    }

    private static boolean isFlowLogEnable() {
        return ConfigurationManager.getInstance().getServerConfig().getLogRate() - rand.nextInt(100) > 0;
    }

    private static String encodeStringParam(String longParam, int len) {
        if (longParam == null || longParam.length() == 0) {
            return "";
        }
        String shortParam = longParam;
        if (len > 0) {
            shortParam = longParam.length() > len ? longParam.substring(0, len) + "..(" + longParam.length() + ")" : longParam;
        }
        return shortParam.replaceAll(" ", "_").replaceAll(" ", "_").replaceAll("\n", "+").replace(',', '\uff0c').replace('(', '\uff08').replace(')', '\uff09');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response process(Request req, Session session) {
        TarsServantResponse response;
        block22: {
            TarsServantRequest request = null;
            response = null;
            ServantHomeSkeleton skeleton = null;
            Object value = null;
            AppContext appContext = null;
            ClassLoader oldClassLoader = null;
            int waitingTime = -1;
            long startTime = req.getProcessTime();
            String remark = "";
            try {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                request = (TarsServantRequest)req;
                response = this.createResponse(request, session);
                response.setTicketNumber(req.getTicketNumber());
                if (TarsHelper.isPing(request.getFunctionName())) {
                    TarsServantResponse tarsServantResponse = response;
                    return tarsServantResponse;
                }
                if (response.getRet() != 0) {
                    throw new ServerDecodeException(response.getRet(), "decode error.");
                }
                int maxWaitingTimeInQueue = ConfigurationManager.getInstance().getServerConfig().getServantAdapterConfMap().get(request.getServantName()).getQueueTimeout();
                waitingTime = (int)(startTime - req.getBornTime());
                if (waitingTime > maxWaitingTimeInQueue) {
                    throw new ServerOverloadException(-9, "queue timeout.");
                }
                Context<TarsServantRequest, TarsServantResponse> context = ContextManager.registerContext(request, response);
                context.setAttribute("internal.startTime", startTime);
                context.setAttribute("internal.requestIp", session.getRemoteIp());
                context.setAttribute("internal.requestService", request.getServantName());
                context.setAttribute("internal.requestMethod", request.getFunctionName());
                context.setAttribute("internal.sessionData", session);
                DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
                distributedContext.put("request", (Object)request);
                distributedContext.put("response", (Object)response);
                distributedContext.put("internal_servant", (Object)request.getServantName());
                appContext = AppContextManager.getInstance().getAppContext();
                if (appContext == null) {
                    throw new ServerNoServantException(-4, "empty appContext.");
                }
                this.preInvokeSkeleton();
                skeleton = appContext.getCapHomeSkeleton(request.getServantName());
                if (skeleton == null) {
                    throw new ServerNoServantException(-4, "empty servantImp.");
                }
                List<Filter> filters = AppContextManager.getInstance().getAppContext().getFilters(FilterKind.SERVER);
                TarsServerFilterChain filterChain = new TarsServerFilterChain(filters, request.getServantName(), FilterKind.SERVER, skeleton);
                filterChain.doFilter(request, response);
            }
            catch (Throwable cause) {
                cause.printStackTrace();
                System.err.println("ERROR: " + cause.getMessage());
                int errCode = -99;
                if (cause instanceof ServerException) {
                    errCode = ((ServerException)cause).getRet();
                } else if (cause instanceof InvocationTargetException) {
                    errCode = -10;
                } else if (cause instanceof IllegalArgumentException) {
                    errCode = -1;
                }
                if (response.isAsyncMode()) {
                    try {
                        Context context = ContextManager.getContext();
                        AsyncContext aContext = (AsyncContext)context.getAttribute("internal.asynccontext");
                        if (aContext != null) {
                            aContext.writeException(cause);
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        System.out.println("ERROR: " + ex.getMessage());
                    }
                    break block22;
                }
                response.setResult(null);
                response.setCause(cause);
                response.setRet(errCode);
                remark = cause.toString();
            }
            finally {
                if (oldClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                ContextManager.releaseContext();
                if (!response.isAsyncMode()) {
                    TarsServantProcessor.printServiceFlowLog(flowLogger, request, response.getRet(), System.currentTimeMillis() - startTime, remark);
                }
                this.postInvokeSkeleton();
                OmServiceMngr.getInstance().reportWaitingTimeProperty(waitingTime);
                this.reportServerStat(request, response, startTime);
            }
        }
        return response;
    }

    public void overload(Request req, Session session) {
        TarsServantRequest request = (TarsServantRequest)req;
        TarsServantResponse response = this.createResponse(request, session);
        if (!TarsHelper.isPing(request.getFunctionName()) && response.getRet() == 0) {
            response.setRet(-9);
        }
        try {
            session.write((Response)response);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void reportServerStat(TarsServantRequest request, TarsServantResponse response, long startTime) {
        if (request.getVersion() == 2 || request.getVersion() == 3) {
            this.reportServerStat("tup_client", request, response, startTime);
        } else if (request.getMessageType() == 1) {
            this.reportServerStat("one_way_client", request, response, startTime);
        }
    }

    private void reportServerStat(String moduleName, TarsServantRequest request, TarsServantResponse response, long startTime) {
        ServerConfig serverConfig = ConfigurationManager.getInstance().getServerConfig();
        ServantAdapterConfig servantAdapterConfig = serverConfig.getServantAdapterConfMap().get(request.getServantName());
        if (servantAdapterConfig == null) {
            return;
        }
        CommunicatorConfig communicatorConfig = serverConfig.getCommunicatorConfig();
        Endpoint serverEndpoint = servantAdapterConfig.getEndpoint();
        String masterIp = request.getIoSession().getRemoteIp();
        int result = response.getRet() == 0 ? 0 : 1;
        InvokeStatHelper.getInstance().addProxyStat(request.getServantName()).addInvokeTimeByServer(moduleName, serverConfig.getApplication(), serverConfig.getServerName(), communicatorConfig.getSetName(), communicatorConfig.getSetArea(), communicatorConfig.getSetID(), request.getFunctionName(), masterIp == null ? "0.0.0.0" : masterIp, serverEndpoint.host(), serverEndpoint.port(), result, System.currentTimeMillis() - startTime);
    }

    private TarsServantResponse createResponse(TarsServantRequest request, Session session) {
        TarsServantResponse response = new TarsServantResponse(session);
        response.setRet(request.getRet());
        response.setVersion(request.getVersion());
        response.setPacketType(request.getPacketType());
        response.setMessageType(request.getMessageType());
        response.setStatus(request.getStatus());
        response.setRequest(request);
        response.setCharsetName(request.getCharsetName());
        response.setTimeout(request.getTimeout());
        response.setContext(request.getContext());
        return response;
    }

    public void preInvokeSkeleton() {
        DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
        Request request = (Request)distributedContext.get("request");
        if (request instanceof TarsServantRequest) {
            TarsServantRequest tarsServantRequest = (TarsServantRequest)request;
            this.initDyeing(tarsServantRequest);
        }
    }

    public void postInvokeSkeleton() {
        DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
        distributedContext.clear();
    }

    private void initDyeing(TarsServantRequest request) {
        Object[] parameters;
        Object value;
        if ((request.getMessageType() & 4) == 4) {
            String routeKey = request.getStatus().get("STATUS_DYED_KEY");
            String fileName = request.getStatus().get("STATUS_DYED_FILENAME");
            DyeingSwitch.enableUnactiveDyeing(routeKey, fileName);
            return;
        }
        String cache_routeKey = DyeingKeyCache.getInstance().get(request.getServantName(), request.getFunctionName());
        if (cache_routeKey == null) {
            cache_routeKey = DyeingKeyCache.getInstance().get(request.getServantName(), "DyeingAllFunctionsFromInterface");
        }
        if (cache_routeKey == null) {
            return;
        }
        TarsMethodInfo methodInfo = request.getMethodInfo();
        if (methodInfo.getRouteKeyIndex() != -1 && cache_routeKey.equals((value = (parameters = request.getMethodParameters())[methodInfo.getRouteKeyIndex()]).toString())) {
            String routeKey = cache_routeKey;
            String fileName = ConfigurationManager.getInstance().getServerConfig().getServerName();
            DyeingSwitch.enableUnactiveDyeing(routeKey, fileName);
        }
    }
}

