/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.property;

import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.support.property.PropertyReportHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CommonPropertyPolicy {

    public static class Count
    implements PropertyReportHelper.Policy {
        private final AtomicInteger n = new AtomicInteger(0);

        @Override
        public String desc() {
            return "Count";
        }

        @Override
        public String get() {
            return String.valueOf(this.n.getAndSet(0));
        }

        @Override
        public void set(int v) {
            this.n.incrementAndGet();
        }
    }

    public static class Avg
    implements PropertyReportHelper.Policy {
        private final AtomicInteger cnt = new AtomicInteger(0);
        private final AtomicInteger sum = new AtomicInteger(0);

        @Override
        public String desc() {
            return "Avg";
        }

        @Override
        public String get() {
            int cnt = this.cnt.getAndSet(0);
            int sum = this.sum.getAndSet(0);
            if (cnt <= 0) {
                return "0";
            }
            return String.valueOf((double)sum / (double)cnt);
        }

        @Override
        public void set(int v) {
            this.cnt.incrementAndGet();
            this.sum.addAndGet(v);
        }
    }

    public static class Distr
    implements PropertyReportHelper.Policy {
        private static final Integer[] II = new Integer[0];
        private Integer[] data;
        private int[] result;

        public Distr(List<Integer> list) {
            if (list == null || list.size() == 0) {
                throw new TarsException("PropertyReport|Distr initial list object can not be empty");
            }
            this.data = new HashSet<Integer>(list).toArray(II);
            Arrays.sort((Object[])this.data);
            this.result = new int[this.data.length];
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = 0;
            }
        }

        private synchronized void clear() {
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = 0;
            }
        }

        @Override
        public String desc() {
            return "Distr";
        }

        @Override
        public synchronized String get() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(i != 0 ? "," : "").append(this.data[i]).append("|").append(this.result[i]);
            }
            this.clear();
            return sb.toString();
        }

        @Override
        public synchronized void set(int value) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] <= value) continue;
                int n = i;
                this.result[n] = this.result[n] + 1;
                break;
            }
        }
    }

    public static class Max
    implements PropertyReportHelper.Policy {
        private final AtomicInteger n = new AtomicInteger(Integer.MIN_VALUE);

        @Override
        public String desc() {
            return "Max";
        }

        @Override
        public String get() {
            return String.valueOf(this.n.getAndSet(Integer.MIN_VALUE));
        }

        @Override
        public void set(int v) {
            int old;
            do {
                if (v > (old = this.n.get())) continue;
                return;
            } while (!this.n.compareAndSet(old, v));
        }
    }

    public static class Min
    implements PropertyReportHelper.Policy {
        private final AtomicInteger n = new AtomicInteger(Integer.MAX_VALUE);

        @Override
        public String desc() {
            return "Min";
        }

        @Override
        public String get() {
            return String.valueOf(this.n.getAndSet(Integer.MAX_VALUE));
        }

        @Override
        public void set(int v) {
            int old;
            do {
                if (v < (old = this.n.get())) continue;
                return;
            } while (!this.n.compareAndSet(old, v));
        }
    }

    public static class Sum
    implements PropertyReportHelper.Policy {
        private final AtomicInteger n = new AtomicInteger(0);

        @Override
        public String desc() {
            return "Sum";
        }

        @Override
        public String get() {
            return String.valueOf(this.n.getAndSet(0));
        }

        @Override
        public void set(int v) {
            this.n.addAndGet(v);
        }
    }
}

