/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Geoshape {
    private static final SpatialContext CTX = SpatialContext.GEO;
    private final float[][] coordinates;

    private Geoshape() {
        this.coordinates = null;
    }

    private Geoshape(float[][] coordinates) {
        Preconditions.checkArgument((coordinates != null && coordinates.length == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((coordinates[0].length == coordinates[1].length && coordinates[0].length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < coordinates[0].length; ++i) {
            if (Float.isNaN(coordinates[0][i])) {
                Preconditions.checkArgument((i == 1 && coordinates.length == 2 && coordinates[1][i] > 0.0f ? 1 : 0) != 0);
                continue;
            }
            Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(coordinates[0][i], coordinates[1][i]));
        }
        this.coordinates = coordinates;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.coordinates[0]).append(this.coordinates[1]).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        Geoshape oth = (Geoshape)other;
        Preconditions.checkArgument((this.coordinates.length == 2 && oth.coordinates.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (this.coordinates[i].length != oth.coordinates[i].length) {
                return false;
            }
            for (int j = 0; j < this.coordinates[i].length; ++j) {
                if (Float.isNaN(this.coordinates[i][j]) && Float.isNaN(oth.coordinates[i][j]) || this.coordinates[i][j] == oth.coordinates[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Type type = this.getType();
        StringBuilder s = new StringBuilder();
        s.append(type.toString().toLowerCase());
        switch (type) {
            case POINT: {
                s.append(this.getPoint().toString());
                break;
            }
            case CIRCLE: {
                s.append(this.getPoint().toString()).append(":").append(this.getRadius());
                break;
            }
            default: {
                s.append("[");
                for (int i = 0; i < this.size(); ++i) {
                    if (i > 0) {
                        s.append(",");
                    }
                    s.append(this.getPoint(i));
                }
                s.append("]");
            }
        }
        return s.toString();
    }

    public Type getType() {
        if (this.coordinates[0].length == 1) {
            return Type.POINT;
        }
        if (this.coordinates[0].length > 2) {
            return Type.POLYGON;
        }
        if (Float.isNaN(this.coordinates[0][1])) {
            return Type.CIRCLE;
        }
        return Type.BOX;
    }

    public int size() {
        switch (this.getType()) {
            case POINT: {
                return 1;
            }
            case CIRCLE: {
                return 1;
            }
            case BOX: {
                return 2;
            }
            case POLYGON: {
                return this.coordinates[0].length;
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)this.getType()));
    }

    public Point getPoint(int position) {
        if (position < 0 || position >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        return new Point(this.coordinates[0][position], this.coordinates[1][position]);
    }

    public Point getPoint() {
        Preconditions.checkArgument((this.size() == 1 ? 1 : 0) != 0, (Object)"Shape does not have a single point");
        return this.getPoint(0);
    }

    public float getRadius() {
        Preconditions.checkArgument((this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"This shape is not a circle");
        return this.coordinates[1][1];
    }

    private SpatialRelation getSpatialRelation(Geoshape other) {
        Preconditions.checkNotNull((Object)other);
        return this.convert2Spatial4j().relate(other.convert2Spatial4j());
    }

    public boolean intersect(Geoshape other) {
        SpatialRelation r = this.getSpatialRelation(other);
        return r == SpatialRelation.INTERSECTS || r == SpatialRelation.CONTAINS || r == SpatialRelation.WITHIN;
    }

    public boolean within(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.WITHIN;
    }

    public boolean disjoint(Geoshape other) {
        return this.getSpatialRelation(other) == SpatialRelation.DISJOINT;
    }

    public Shape convert2Spatial4j() {
        switch (this.getType()) {
            case POINT: {
                return this.getPoint().getSpatial4jPoint();
            }
            case CIRCLE: {
                return CTX.makeCircle(this.getPoint(0).getSpatial4jPoint(), DistanceUtils.dist2Degrees((double)this.getRadius(), (double)6371.0087714));
            }
            case BOX: {
                return CTX.makeRectangle(this.getPoint(0).getSpatial4jPoint(), this.getPoint(1).getSpatial4jPoint());
            }
            case POLYGON: {
                throw new UnsupportedOperationException("Not yet supported");
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)this.getType()));
    }

    public static final Geoshape point(float latitude, float longitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        return new Geoshape(new float[][]{{latitude}, {longitude}});
    }

    public static final Geoshape point(double latitude, double longitude) {
        return Geoshape.point((float)latitude, (float)longitude);
    }

    public static final Geoshape circle(float latitude, float longitude, float radiusInKM) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        Preconditions.checkArgument((radiusInKM > 0.0f ? 1 : 0) != 0, (String)"Invalid radius provided [%s]", (Object[])new Object[]{Float.valueOf(radiusInKM)});
        return new Geoshape(new float[][]{{latitude, Float.NaN}, {longitude, radiusInKM}});
    }

    public static final Geoshape circle(double latitude, double longitude, double radiusInKM) {
        return Geoshape.circle((float)latitude, (float)longitude, (float)radiusInKM);
    }

    public static final Geoshape box(float southWestLatitude, float southWestLongitude, float northEastLatitude, float northEastLongitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(southWestLatitude, southWestLongitude), (Object)"Invalid south-west coordinate provided");
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(northEastLatitude, northEastLongitude), (Object)"Invalid north-east coordinate provided");
        return new Geoshape(new float[][]{{southWestLatitude, northEastLatitude}, {southWestLongitude, northEastLongitude}});
    }

    public static final Geoshape box(double southWestLatitude, double southWestLongitude, double northEastLatitude, double northEastLongitude) {
        return Geoshape.box((float)southWestLatitude, (float)southWestLongitude, (float)northEastLatitude, (float)northEastLongitude);
    }

    public static final boolean isValidCoordinate(float latitude, float longitude) {
        return (double)latitude >= -90.0 && (double)latitude <= 90.0 && (double)longitude >= -180.0 && (double)longitude <= 180.0;
    }

    public static final class Point {
        private final float longitude;
        private final float latitude;

        Point(float latitude, float longitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public float getLongitude() {
            return this.longitude;
        }

        public float getLatitude() {
            return this.latitude;
        }

        private com.spatial4j.core.shape.Point getSpatial4jPoint() {
            return CTX.makePoint((double)this.longitude, (double)this.latitude);
        }

        public double distance(Point other) {
            return DistanceUtils.degrees2Dist((double)CTX.getDistCalc().distance(this.getSpatial4jPoint(), other.getSpatial4jPoint()), (double)6371.0087714);
        }

        public String toString() {
            return "[" + this.latitude + "," + this.longitude + "]";
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.latitude).append(this.longitude).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().isInstance(other)) {
                return false;
            }
            Point oth = (Point)other;
            return this.latitude == oth.latitude && this.longitude == oth.longitude;
        }
    }

    public static enum Type {
        POINT,
        BOX,
        CIRCLE,
        POLYGON;

    }
}

