/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TransactionHandle;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendTransaction
implements TransactionHandle {
    private static final Logger log = LoggerFactory.getLogger(BackendTransaction.class);
    public static final int MIN_TASKS_TO_PARALLELIZE = 2;
    public static final StaticBuffer EDGESTORE_MIN_KEY = ByteBufferUtil.zeroBuffer(8);
    public static final StaticBuffer EDGESTORE_MAX_KEY = ByteBufferUtil.oneBuffer(8);
    private final StoreTransaction storeTx;
    private final StoreFeatures storeFeatures;
    private final KeyColumnValueStore edgeStore;
    private final KeyColumnValueStore vertexIndexStore;
    private final KeyColumnValueStore edgeIndexStore;
    private final int maxReadRetryAttempts;
    private final int retryStorageWaitTime;
    private final Executor threadPool;
    private final Map<String, IndexTransaction> indexTx;

    public BackendTransaction(StoreTransaction storeTx, StoreFeatures features, KeyColumnValueStore edgeStore, KeyColumnValueStore vertexIndexStore, KeyColumnValueStore edgeIndexStore, int maxReadRetryAttempts, int retryStorageWaitTime, Map<String, IndexTransaction> indexTx, Executor threadPool) {
        this.storeTx = storeTx;
        this.storeFeatures = features;
        this.edgeStore = edgeStore;
        this.vertexIndexStore = vertexIndexStore;
        this.edgeIndexStore = edgeIndexStore;
        this.maxReadRetryAttempts = maxReadRetryAttempts;
        this.retryStorageWaitTime = retryStorageWaitTime;
        this.indexTx = indexTx;
        this.threadPool = threadPool;
    }

    public StoreTransaction getStoreTransactionHandle() {
        return this.storeTx;
    }

    public IndexTransaction getIndexTransactionHandle(String index) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)index));
        IndexTransaction itx = this.indexTx.get(index);
        Preconditions.checkNotNull((Object)itx, (Object)("Unknown index: " + index));
        return itx;
    }

    @Override
    public void commit() throws StorageException {
        this.storeTx.commit();
        for (IndexTransaction itx : this.indexTx.values()) {
            itx.commit();
        }
    }

    @Override
    public void rollback() throws StorageException {
        this.storeTx.rollback();
        for (IndexTransaction itx : this.indexTx.values()) {
            itx.rollback();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.storeTx.flush();
        for (IndexTransaction itx : this.indexTx.values()) {
            itx.flush();
        }
    }

    public void mutateEdges(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions) throws StorageException {
        this.edgeStore.mutate(key, additions, deletions, this.storeTx);
    }

    public void mutateVertexIndex(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions) throws StorageException {
        this.vertexIndexStore.mutate(key, additions, deletions, this.storeTx);
    }

    public void mutateEdgeIndex(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions) throws StorageException {
        this.edgeIndexStore.mutate(key, additions, deletions, this.storeTx);
    }

    public void acquireEdgeLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue) throws StorageException {
        this.edgeStore.acquireLock(key, column, expectedValue, this.storeTx);
    }

    public void acquireVertexIndexLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue) throws StorageException {
        this.vertexIndexStore.acquireLock(key, column, expectedValue, this.storeTx);
    }

    public List<Entry> edgeStoreQuery(final KeySliceQuery query) {
        return this.executeRead(new Callable<List<Entry>>(){

            @Override
            public List<Entry> call() throws Exception {
                return BackendTransaction.this.edgeStore.getSlice(query, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreQuery";
            }
        });
    }

    public List<List<Entry>> edgeStoreMultiQuery(final List<StaticBuffer> keys, final SliceQuery query) {
        List<List<Entry>> results;
        if (this.storeFeatures.supportsMultiQuery()) {
            return this.executeRead(new Callable<List<List<Entry>>>(){

                @Override
                public List<List<Entry>> call() throws Exception {
                    return BackendTransaction.this.edgeStore.getSlice(keys, query, BackendTransaction.this.storeTx);
                }

                public String toString() {
                    return "MultiEdgeStoreQuery";
                }
            });
        }
        if (this.threadPool == null || keys.size() < 2) {
            results = new ArrayList<List<Entry>>(keys.size());
            for (StaticBuffer key : keys) {
                results.add(this.edgeStoreQuery(new KeySliceQuery(key, query)));
            }
        } else {
            CountDownLatch doneSignal = new CountDownLatch(keys.size());
            AtomicInteger failureCount = new AtomicInteger(0);
            Object[] resultArray = new List[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                this.threadPool.execute(new SliceQueryRunner(new KeySliceQuery(keys.get(i), query), doneSignal, failureCount, resultArray, i));
            }
            try {
                doneSignal.await();
            }
            catch (InterruptedException e) {
                throw new TitanException("Interrupted while waiting for multi-query to complete", e);
            }
            if (failureCount.get() > 0) {
                throw new TitanException("Could not successfully complete multi-query. " + failureCount.get() + " individual queries failed.");
            }
            results = Arrays.asList(resultArray);
            assert (keys.size() == results.size());
            for (List<Entry> l : results) {
                assert (l != null);
            }
        }
        return results;
    }

    public boolean edgeStoreContainsKey(final StaticBuffer key) {
        return this.executeRead(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BackendTransaction.this.edgeStore.containsKey(key, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreContainsKey";
            }
        });
    }

    public KeyIterator edgeStoreKeys(final SliceQuery sliceQuery) {
        if (!this.storeFeatures.supportsScan()) {
            throw new UnsupportedOperationException("The configured storage backend does not support global graph operations - use Faunus instead");
        }
        return this.executeRead(new Callable<KeyIterator>(){

            @Override
            public KeyIterator call() throws Exception {
                return BackendTransaction.this.storeFeatures.isKeyOrdered() ? BackendTransaction.this.edgeStore.getKeys(new KeyRangeQuery(EDGESTORE_MIN_KEY, EDGESTORE_MAX_KEY, sliceQuery), BackendTransaction.this.storeTx) : BackendTransaction.this.edgeStore.getKeys(sliceQuery, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreKeys";
            }
        });
    }

    public KeyIterator edgeStoreKeys(final KeyRangeQuery range) {
        Preconditions.checkArgument((boolean)this.storeFeatures.supportsOrderedScan(), (Object)"The configured storage backend does not support ordered scans");
        return this.executeRead(new Callable<KeyIterator>(){

            @Override
            public KeyIterator call() throws Exception {
                return BackendTransaction.this.edgeStore.getKeys(range, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreKeys";
            }
        });
    }

    public List<Entry> vertexIndexQuery(final KeySliceQuery query) {
        return this.executeRead(new Callable<List<Entry>>(){

            @Override
            public List<Entry> call() throws Exception {
                return BackendTransaction.this.vertexIndexStore.getSlice(query, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "VertexIndexQuery";
            }
        });
    }

    public List<Entry> edgeIndexQuery(final KeySliceQuery query) {
        return this.executeRead(new Callable<List<Entry>>(){

            @Override
            public List<Entry> call() throws Exception {
                return BackendTransaction.this.edgeIndexStore.getSlice(query, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeIndexQuery";
            }
        });
    }

    public List<String> indexQuery(String index, final IndexQuery query) {
        final IndexTransaction indexTx = this.getIndexTransactionHandle(index);
        return this.executeRead(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return indexTx.query(query);
            }

            public String toString() {
                return "IndexQuery";
            }
        });
    }

    public Iterable<RawQuery.Result<String>> rawQuery(String index, final RawQuery query) {
        final IndexTransaction indexTx = this.getIndexTransactionHandle(index);
        return this.executeRead(new Callable<Iterable<RawQuery.Result<String>>>(){

            @Override
            public Iterable<RawQuery.Result<String>> call() throws Exception {
                return indexTx.query(query);
            }

            public String toString() {
                return "RawQuery";
            }
        });
    }

    private final <V> V executeRead(Callable<V> exe) throws TitanException {
        return BackendOperation.execute(exe, this.maxReadRetryAttempts, this.retryStorageWaitTime);
    }

    private class SliceQueryRunner
    implements Runnable {
        final KeySliceQuery kq;
        final CountDownLatch doneSignal;
        final AtomicInteger failureCount;
        final Object[] resultArray;
        final int resultPosition;

        private SliceQueryRunner(KeySliceQuery kq, CountDownLatch doneSignal, AtomicInteger failureCount, Object[] resultArray, int resultPosition) {
            this.kq = kq;
            this.doneSignal = doneSignal;
            this.failureCount = failureCount;
            this.resultArray = resultArray;
            this.resultPosition = resultPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List<Entry> result = BackendTransaction.this.maxReadRetryAttempts > 1 ? BackendTransaction.this.edgeStoreQuery(this.kq) : BackendTransaction.this.edgeStore.getSlice(this.kq, BackendTransaction.this.storeTx);
                this.resultArray[this.resultPosition] = result;
            }
            catch (Exception e) {
                this.failureCount.incrementAndGet();
                log.warn("Individual query in multi-transaction failed: ", (Throwable)e);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

