/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.common;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributedStoreManager
extends AbstractStoreManager {
    private static final Logger log = LoggerFactory.getLogger(DistributedStoreManager.class);
    private static final Random random = new Random();
    protected final byte[] rid;
    protected final String[] hostnames;
    protected final int port;
    protected final int connectionTimeout;
    protected final int connectionPoolSize;
    protected final int pageSize;
    protected final String username;
    protected final String password;

    public DistributedStoreManager(Configuration storageConfig, int portDefault) {
        super(storageConfig);
        this.hostnames = storageConfig.containsKey("hostname") ? storageConfig.getStringArray("hostname") : new String[]{"127.0.0.1"};
        Preconditions.checkArgument((this.hostnames.length > 0 ? 1 : 0) != 0, (Object)"No hostname configured");
        this.port = storageConfig.getInt("port", portDefault);
        this.rid = DistributedStoreManager.getRid(storageConfig);
        this.connectionTimeout = storageConfig.getInt("connection-timeout", 10000);
        this.connectionPoolSize = storageConfig.getInt("connection-pool-size", 32);
        this.pageSize = storageConfig.getInt("page-size", 100);
        this.username = storageConfig.getString("username", null);
        this.password = storageConfig.getString("password", null);
    }

    protected String getSingleHostname() {
        return this.hostnames[random.nextInt(this.hostnames.length)];
    }

    public boolean hasAuthentication() {
        return this.username != null;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String toString() {
        String hn = this.getSingleHostname();
        return hn.substring(0, Math.min(hn.length(), 256)) + ":" + this.port;
    }

    public static byte[] getRid(Configuration config) {
        byte[] tentativeRid = null;
        if (config.containsKey("machine-id")) {
            String ridText = config.getString("machine-id");
            try {
                tentativeRid = Hex.decodeHex((char[])ridText.toCharArray());
            }
            catch (DecoderException e) {
                throw new TitanConfigurationException("Could not decode hex value", e);
            }
            log.debug("Set rid from hex string: 0x{}", (Object)ridText);
        } else {
            byte[] addrBytes;
            byte[] endBytes;
            if (config.containsKey("machine-id-appendix")) {
                short s = config.getShort("machine-id-appendix");
                endBytes = new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)};
            } else {
                endBytes = (String.valueOf(Thread.currentThread().getId()) + "@" + ManagementFactory.getRuntimeMXBean().getName()).getBytes();
            }
            try {
                addrBytes = Inet4Address.getLocalHost().getAddress();
            }
            catch (UnknownHostException e) {
                throw new TitanConfigurationException("Unknown host specified", e);
            }
            tentativeRid = new byte[addrBytes.length + endBytes.length];
            System.arraycopy(addrBytes, 0, tentativeRid, 0, addrBytes.length);
            System.arraycopy(endBytes, 0, tentativeRid, addrBytes.length, endBytes.length);
            if (log.isDebugEnabled()) {
                log.debug("Set rid: 0x{}", (Object)new String(Hex.encodeHex((byte[])tentativeRid)));
            }
        }
        return tentativeRid;
    }

    protected Timestamp getTimestamp(StoreTransaction txh) {
        long time = txh.getConfiguration().getTimestamp();
        return new Timestamp((time &= 0xFFFFFFFFFFFFFFFEL) | 1L, time);
    }

    public static class Timestamp {
        public final long additionTime;
        public final long deletionTime;

        public Timestamp(long additionTime, long deletionTime) {
            Preconditions.checkArgument((0L < deletionTime ? 1 : 0) != 0, (String)"Negative time: %s", (Object[])new Object[]{deletionTime});
            Preconditions.checkArgument((deletionTime < additionTime ? 1 : 0) != 0, (String)"%s vs %s", (Object[])new Object[]{deletionTime, additionTime});
            this.additionTime = additionTime;
            this.deletionTime = deletionTime;
        }
    }

    public static enum Deployment {
        REMOTE,
        LOCAL,
        EMBEDDED;

    }
}

