/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.idmanagement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractIDManager
implements IDAuthority {
    protected static final long BASE_ID = 1L;
    protected final long idApplicationWaitMS;
    protected final int idApplicationRetryCount;
    protected final byte[] rid;
    protected final String metricsPrefix;
    private IDBlockSizer blockSizer;
    private volatile boolean isActive;

    public AbstractIDManager(Configuration config) {
        this.rid = DistributedStoreManager.getRid(config);
        this.isActive = false;
        this.idApplicationWaitMS = config.getLong("idauthority-wait-time", 300L);
        this.idApplicationRetryCount = config.getInt("idauthority-retries", 20);
        this.metricsPrefix = GraphDatabaseConfiguration.getSystemMetricsPrefix();
    }

    @Override
    public synchronized void setIDBlockSizer(IDBlockSizer sizer) {
        Preconditions.checkNotNull((Object)sizer);
        if (this.isActive) {
            throw new IllegalStateException("IDBlockSizer cannot be changed after IDAuthority is in use");
        }
        this.blockSizer = sizer;
    }

    protected StaticBuffer getPartitionKey(int partition) {
        return ByteBufferUtil.getIntBuffer(partition);
    }

    protected long getBlockSize(int partition) {
        Preconditions.checkArgument((this.blockSizer != null ? 1 : 0) != 0, (Object)"Blocksizer has not yet been initialized");
        this.isActive = true;
        long blockSize = this.blockSizer.getBlockSize(partition);
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"Invalid block size: %s", (Object[])new Object[]{blockSize});
        Preconditions.checkArgument((blockSize < this.getIdUpperBound(partition) ? 1 : 0) != 0, (String)"Block size [%s] cannot be larger than upper bound [%s] for partition [%s]", (Object[])new Object[]{blockSize, this.getIdUpperBound(partition), partition});
        return blockSize;
    }

    protected long getIdUpperBound(int partition) {
        Preconditions.checkArgument((this.blockSizer != null ? 1 : 0) != 0, (Object)"Blocksizer has not yet been initialized");
        this.isActive = true;
        long upperBound = this.blockSizer.getIdUpperBound(partition);
        Preconditions.checkArgument((upperBound > 0L ? 1 : 0) != 0, (String)"Invalid upper bound: %s", (Object[])new Object[]{upperBound});
        return upperBound;
    }
}

