/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.idmanagement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.idmanagement.AbstractIDManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ConsistencyLevel;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.TimeUtility;
import com.thinkaurelius.titan.diskstorage.util.WriteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentKeyIDManager
extends AbstractIDManager
implements BackendOperation.TransactionalProvider {
    private static final Logger log = LoggerFactory.getLogger(ConsistentKeyIDManager.class);
    private static final StaticBuffer LOWER_SLICE = ByteBufferUtil.zeroBuffer(16);
    private static final StaticBuffer UPPER_SLICE = ByteBufferUtil.oneBuffer(16);
    private final StoreManager manager;
    private final KeyColumnValueStore idStore;
    private final int rollbackAttempts = 5;
    private final int rollbackWaitTime = 200;
    private final int uniqueIdBitWidth;
    private final int uniqueIDUpperBound;
    private final int uniqueId;
    private final boolean randomizeUniqueId;
    private final ConsistencyLevel consistencLevel;
    private final Random random = new Random();

    public ConsistentKeyIDManager(KeyColumnValueStore idStore, StoreManager manager, Configuration config) throws StorageException {
        super(config);
        Preconditions.checkArgument((boolean)manager.getFeatures().supportsConsistentKeyOperations());
        this.manager = manager;
        this.idStore = idStore;
        this.uniqueIdBitWidth = config.getInt("idauthority-uniqueid-bits", 0);
        Preconditions.checkArgument((this.uniqueIdBitWidth >= 0 && this.uniqueIdBitWidth <= 16 ? 1 : 0) != 0, (String)"Invalid unique id bit width defined [%s]. Must be in [0,16]", (Object[])new Object[]{this.uniqueIdBitWidth});
        this.uniqueIDUpperBound = 1 << this.uniqueIdBitWidth;
        if (config.getBoolean("idauthority-uniqueid-random", false)) {
            Preconditions.checkArgument((!config.containsKey("idauthority-uniqueid") ? 1 : 0) != 0, (Object)"Conflicting configuration: a unique id and randomization have been set");
            Preconditions.checkArgument((!config.getBoolean("idauthority-local-consistency", false) ? 1 : 0) != 0, (Object)"Cannot use local consistency with randomization - this leads to data corruption");
            this.randomizeUniqueId = true;
            this.uniqueId = -1;
            this.consistencLevel = ConsistencyLevel.KEY_CONSISTENT;
        } else {
            this.randomizeUniqueId = false;
            if (config.getBoolean("idauthority-local-consistency", false)) {
                Preconditions.checkArgument((boolean)config.containsKey("idauthority-uniqueid"), (Object)"Need to configure a unique id in order to use local consistency");
                this.consistencLevel = ConsistencyLevel.LOCAL_KEY_CONSISTENT;
            } else {
                this.consistencLevel = ConsistencyLevel.KEY_CONSISTENT;
            }
            this.uniqueId = config.getInt("idauthority-uniqueid", 0);
            Preconditions.checkArgument((this.uniqueId >= 0 ? 1 : 0) != 0, (String)"Invalid unique id: %s", (Object[])new Object[]{this.uniqueId});
            Preconditions.checkArgument((this.uniqueId < this.uniqueIDUpperBound ? 1 : 0) != 0, (String)"Unique id is too large for bit width [%s]: %s", (Object[])new Object[]{this.uniqueIdBitWidth, this.uniqueId});
        }
    }

    @Override
    public StaticBuffer[] getLocalIDPartition() throws StorageException {
        return this.idStore.getLocalKeyPartition();
    }

    @Override
    public void close() throws StorageException {
        this.idStore.close();
    }

    @Override
    public StoreTransaction openTx() throws StorageException {
        return this.manager.beginTransaction(new StoreTxConfig(this.consistencLevel, this.metricsPrefix));
    }

    private long getCurrentID(final StaticBuffer partitionKey) throws StorageException {
        List<Entry> blocks = BackendOperation.execute(new BackendOperation.Transactional<List<Entry>>(){

            @Override
            public List<Entry> call(StoreTransaction txh) throws StorageException {
                return ConsistentKeyIDManager.this.idStore.getSlice(new KeySliceQuery(partitionKey, LOWER_SLICE, UPPER_SLICE).setLimit(5), txh);
            }
        }, this);
        if (blocks == null) {
            throw new TemporaryStorageException("Could not read from storage");
        }
        long latest = 1L;
        for (Entry e : blocks) {
            long counterVal = this.getBlockValue(e.getReadColumn());
            if (latest >= counterVal) continue;
            latest = counterVal;
        }
        return latest;
    }

    private int getUniqueID() {
        int id = this.randomizeUniqueId ? this.random.nextInt(this.uniqueIDUpperBound) : this.uniqueId;
        assert (id >= 0 && id < this.uniqueIDUpperBound);
        return id;
    }

    protected StaticBuffer getPartitionKey(int partition, int uniqueId) {
        if (this.uniqueIdBitWidth == 0) {
            return ByteBufferUtil.getIntBuffer(partition);
        }
        return ByteBufferUtil.getIntBuffer(new int[]{partition, uniqueId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] getIDBlock(int partition) throws StorageException {
        long blockSize = this.getBlockSize(partition);
        long idUpperBound = this.getIdUpperBound(partition);
        int bitOffset = VariableLong.unsignedBitLength(idUpperBound) - 1 - this.uniqueIdBitWidth;
        Preconditions.checkArgument((bitOffset > 0 ? 1 : 0) != 0, (String)"Unique id bit width [%s] is too wide for partition [%s] id bound [%s]", (Object[])new Object[]{this.uniqueIdBitWidth, partition, idUpperBound});
        long idBlockUpperBound = 1L << bitOffset;
        Preconditions.checkArgument((idBlockUpperBound > blockSize ? 1 : 0) != 0, (String)"Block size [%s] is larger than upper bound [%s] for bit width [%s]", (Object[])new Object[]{blockSize, idBlockUpperBound, this.uniqueIdBitWidth});
        block11: for (int retry = 0; retry < this.idApplicationRetryCount; ++retry) {
            int uniqueID = this.getUniqueID();
            try {
                boolean success;
                StaticBuffer target;
                long nextEnd;
                long nextStart;
                StaticBuffer partitionKey;
                block24: {
                    long[] lArray;
                    block25: {
                        partitionKey = this.getPartitionKey(partition, uniqueID);
                        nextStart = this.getCurrentID(partitionKey);
                        if (idBlockUpperBound - blockSize <= nextStart) {
                            log.info("ID overflow detected. Current id {}, block size {} and upper bound {} for bit width {}", new Object[]{nextStart, blockSize, idBlockUpperBound, this.uniqueIdBitWidth});
                            if (this.randomizeUniqueId && retry + 1 < this.idApplicationRetryCount) continue;
                            throw new IDPoolExhaustedException("Exhausted id block for partition [" + partition + "] with upper bound: " + idBlockUpperBound);
                        }
                        assert (idBlockUpperBound - blockSize > nextStart);
                        nextEnd = nextStart + blockSize;
                        target = this.getBlockApplication(nextEnd);
                        success = false;
                        long before = System.currentTimeMillis();
                        BackendOperation.execute(new BackendOperation.Transactional<Boolean>(){

                            @Override
                            public Boolean call(StoreTransaction txh) throws StorageException {
                                ConsistentKeyIDManager.this.idStore.mutate(partitionKey, Arrays.asList(StaticBufferEntry.of(target, ByteBufferUtil.emptyBuffer())), KeyColumnValueStore.NO_DELETIONS, txh);
                                return true;
                            }
                        }, this);
                        long after = System.currentTimeMillis();
                        if (this.idApplicationWaitMS < after - before) {
                            throw new TemporaryStorageException("Wrote claim for id block [" + nextStart + ", " + nextEnd + ") in " + (after - before) + " ms => too slow, threshold is: " + this.idApplicationWaitMS);
                        }
                        assert (0 != target.length());
                        final StaticBuffer[] slice = this.getBlockSlice(nextEnd);
                        TimeUtility.INSTANCE.sleepUntil(after + this.idApplicationWaitMS, log);
                        List<Entry> blocks = BackendOperation.execute(new BackendOperation.Transactional<List<Entry>>(){

                            @Override
                            public List<Entry> call(StoreTransaction txh) throws StorageException {
                                return ConsistentKeyIDManager.this.idStore.getSlice(new KeySliceQuery(partitionKey, slice[0], slice[1]), txh);
                            }
                        }, this);
                        if (blocks == null) {
                            throw new TemporaryStorageException("Could not read from storage");
                        }
                        if (blocks.isEmpty()) {
                            throw new PermanentStorageException("It seems there is a race-condition in the block application. If you have multiple Titan instances running on one physical machine, ensure that they have unique machine idAuthorities");
                        }
                        if (!target.equals(blocks.get(0).getColumn())) break block24;
                        long[] result = new long[]{nextStart, nextEnd};
                        if (log.isDebugEnabled()) {
                            log.debug("Acquired ID block [{},{}) on partition {} (my rid is {})", new Object[]{nextStart, nextEnd, partition, new String(Hex.encodeHex((byte[])this.rid))});
                        }
                        success = true;
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = ((long)uniqueID << bitOffset) + result[i];
                        }
                        lArray = result;
                        if (success) break block25;
                        for (int attempt = 0; attempt < 5; ++attempt) {
                            try {
                                BackendOperation.execute(new BackendOperation.Transactional<Boolean>(partitionKey, target){
                                    final /* synthetic */ StaticBuffer val$partitionKey;
                                    final /* synthetic */ StaticBuffer val$target;
                                    {
                                        this.val$partitionKey = staticBuffer;
                                        this.val$target = staticBuffer2;
                                    }

                                    @Override
                                    public Boolean call(StoreTransaction txh) throws StorageException {
                                        ConsistentKeyIDManager.this.idStore.mutate(this.val$partitionKey, KeyColumnValueStore.NO_ADDITIONS, Arrays.asList(this.val$target), txh);
                                        return true;
                                    }
                                }, new BackendOperation.TransactionalProvider(){

                                    @Override
                                    public StoreTransaction openTx() throws StorageException {
                                        return ConsistentKeyIDManager.this.manager.beginTransaction(new StoreTxConfig(ConsistencyLevel.DEFAULT, ConsistentKeyIDManager.this.metricsPrefix));
                                    }
                                });
                                break;
                            }
                            catch (StorageException e) {
                                log.warn("Storage exception while deleting old block application - retrying in {} ms", (Object)200, (Object)e);
                                TimeUtility.INSTANCE.sleepUntil(System.currentTimeMillis() + 200L, log);
                                continue;
                            }
                        }
                    }
                    return lArray;
                }
                try {
                    log.debug("Failed to acquire ID block [{},{}) (another host claimed it first)", (Object)nextStart, (Object)nextEnd);
                    if (success) continue;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        for (int attempt = 0; attempt < 5; ++attempt) {
                            try {
                                BackendOperation.execute(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
                                break;
                            }
                            catch (StorageException e) {
                                log.warn("Storage exception while deleting old block application - retrying in {} ms", (Object)200, (Object)e);
                                TimeUtility.INSTANCE.sleepUntil(System.currentTimeMillis() + 200L, log);
                                continue;
                            }
                        }
                    }
                    throw throwable;
                }
                for (int attempt = 0; attempt < 5; ++attempt) {
                    try {
                        BackendOperation.execute(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
                        continue block11;
                    }
                    catch (StorageException e) {
                        log.warn("Storage exception while deleting old block application - retrying in {} ms", (Object)200, (Object)e);
                        TimeUtility.INSTANCE.sleepUntil(System.currentTimeMillis() + 200L, log);
                        continue;
                    }
                }
                continue;
            }
            catch (TemporaryStorageException e) {
                log.warn("Temporary storage exception while acquiring id block - retrying in {} ms: {}", (Object)this.idApplicationWaitMS, (Object)e);
                if (this.idApplicationWaitMS <= 0L) continue;
                TimeUtility.INSTANCE.sleepUntil(System.currentTimeMillis() + this.idApplicationWaitMS, log);
            }
        }
        throw new TemporaryLockingException("Exceeded timeout count [" + this.idApplicationRetryCount + "] when attempting to allocate id block");
    }

    private final StaticBuffer[] getBlockSlice(long blockValue) {
        StaticBuffer[] slice = new StaticBuffer[]{new WriteByteBuffer(16).putLong(-blockValue).putLong(0L).getStaticBuffer(), new WriteByteBuffer(16).putLong(-blockValue).putLong(-1L).getStaticBuffer()};
        return slice;
    }

    private final StaticBuffer getBlockApplication(long blockValue) {
        WriteByteBuffer bb = new WriteByteBuffer(16 + this.rid.length);
        bb.putLong(-blockValue).putLong(System.currentTimeMillis());
        WriteBufferUtil.put((WriteBuffer)bb, this.rid);
        return bb.getStaticBuffer();
    }

    private final long getBlockValue(ReadBuffer column) {
        return -column.getLong();
    }
}

