/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class HashPrefixKeyColumnValueStore
implements KeyColumnValueStore {
    private static final String DEFAULT_ALGORITHM = "MD5";
    private final String algorithm = "MD5";
    private final KeyColumnValueStore store;
    private final int numPrefixBytes;

    public HashPrefixKeyColumnValueStore(KeyColumnValueStore store, int numPrefixBytes) {
        Preconditions.checkArgument((numPrefixBytes > 0 && numPrefixBytes <= 16 ? 1 : 0) != 0, (Object)"Invalid number of prefix bytes. Must be in [1,16]");
        this.store = store;
        this.numPrefixBytes = numPrefixBytes;
    }

    private final StaticBuffer prefixKey(StaticBuffer key) {
        try {
            int i;
            MessageDigest m = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            for (int i2 = 0; i2 < key.length(); ++i2) {
                m.update(key.getByte(i2));
            }
            byte[] hash = m.digest();
            byte[] newKey = new byte[this.numPrefixBytes + key.length()];
            for (i = 0; i < this.numPrefixBytes; ++i) {
                newKey[i] = hash[i];
            }
            for (i = 0; i < key.length(); ++i) {
                newKey[this.numPrefixBytes + i] = key.getByte(i);
            }
            return new StaticArrayBuffer(newKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private StaticBuffer truncateKey(StaticBuffer key) {
        return key.subrange(this.numPrefixBytes, key.length() - this.numPrefixBytes);
    }

    @Override
    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws StorageException {
        return this.store.containsKey(this.prefixKey(key), txh);
    }

    @Override
    public List<Entry> getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        KeySliceQuery prefixQuery = new KeySliceQuery(this.prefixKey(query.getKey()), query);
        return this.store.getSlice(prefixQuery, txh);
    }

    @Override
    public List<List<Entry>> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        ArrayList<StaticBuffer> prefixedKeys = new ArrayList<StaticBuffer>(keys.size());
        for (StaticBuffer key : keys) {
            prefixedKeys.add(this.prefixKey(key));
        }
        return this.store.getSlice(prefixedKeys, query, txh);
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        this.store.mutate(this.prefixKey(key), additions, deletions, txh);
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        this.store.acquireLock(this.prefixKey(key), column, expectedValue, txh);
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery keyQuery, StoreTransaction txh) throws StorageException {
        throw new UnsupportedOperationException("getKeys(KeyRangeQuery, StoreTransaction) is not supported in hash prefixed mode.");
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws StorageException {
        return new PrefixedRowIterator(this.store.getKeys(columnQuery, txh));
    }

    @Override
    public StaticBuffer[] getLocalKeyPartition() throws StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    @Override
    public void close() throws StorageException {
        this.store.close();
    }

    private class PrefixedRowIterator
    implements KeyIterator {
        private final KeyIterator rows;

        public PrefixedRowIterator(KeyIterator rows) {
            this.rows = rows;
        }

        @Override
        public RecordIterator<Entry> getEntries() {
            return this.rows.getEntries();
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public StaticBuffer next() {
            return HashPrefixKeyColumnValueStore.this.truncateKey((StaticBuffer)this.rows.next());
        }

        @Override
        public void close() throws IOException {
            this.rows.close();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

