/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferTransaction
implements StoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(BufferTransaction.class);
    private final StoreTransaction tx;
    private final KeyColumnValueStoreManager manager;
    private final int bufferSize;
    private final int mutationAttempts;
    private final int attemptWaitTime;
    private int numMutations;
    private final Map<String, Map<StaticBuffer, KCVMutation>> mutations;

    public BufferTransaction(StoreTransaction tx, KeyColumnValueStoreManager manager, int bufferSize, int attempts, int waitTime) {
        this(tx, manager, bufferSize, attempts, waitTime, 8);
    }

    public BufferTransaction(StoreTransaction tx, KeyColumnValueStoreManager manager, int bufferSize, int attempts, int waitTime, int expectedNumStores) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkArgument((bufferSize > 1 ? 1 : 0) != 0, (Object)"Buffering only makes sense when bufferSize>1");
        this.tx = tx;
        this.manager = manager;
        this.numMutations = 0;
        this.bufferSize = bufferSize;
        this.mutationAttempts = attempts;
        this.attemptWaitTime = waitTime;
        this.mutations = new HashMap<String, Map<StaticBuffer, KCVMutation>>(expectedNumStores);
    }

    public StoreTransaction getWrappedTransactionHandle() {
        return this.tx;
    }

    public void mutate(String store, StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions) throws StorageException {
        KCVMutation existingM;
        Preconditions.checkNotNull((Object)store);
        if (additions.isEmpty() && deletions.isEmpty()) {
            return;
        }
        KCVMutation m = new KCVMutation(additions, deletions);
        Map<StaticBuffer, KCVMutation> storeMutation = this.mutations.get(store);
        if (storeMutation == null) {
            storeMutation = new HashMap<StaticBuffer, KCVMutation>();
            this.mutations.put(store, storeMutation);
        }
        if ((existingM = storeMutation.get(key)) != null) {
            existingM.merge(m);
        } else {
            storeMutation.put(key, m);
        }
        this.numMutations += additions.size();
        this.numMutations += deletions.size();
        if (this.numMutations >= this.bufferSize) {
            this.flushInternal();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.flushInternal();
        this.tx.flush();
    }

    private void flushInternal() throws StorageException {
        if (this.numMutations > 0) {
            BackendOperation.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BufferTransaction.this.manager.mutateMany(BufferTransaction.this.mutations, BufferTransaction.this.tx);
                    return true;
                }

                public String toString() {
                    return "BufferMutation";
                }
            }, this.mutationAttempts, this.attemptWaitTime);
            this.clear();
        }
    }

    private void clear() {
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> entry : this.mutations.entrySet()) {
            entry.getValue().clear();
        }
        this.numMutations = 0;
    }

    @Override
    public void commit() throws StorageException {
        this.flushInternal();
        this.tx.commit();
    }

    @Override
    public void rollback() throws StorageException {
        this.clear();
        this.tx.rollback();
    }

    @Override
    public StoreTxConfig getConfiguration() {
        return this.tx.getConfiguration();
    }
}

