/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class StoreFeatures {
    public Boolean supportsUnorderedScan;
    public Boolean supportsOrderedScan;
    public Boolean supportsBatchMutation;
    public Boolean supportsMultiQuery;
    public Boolean supportsTransactions;
    public Boolean supportsConsistentKeyOperations;
    public Boolean supportsLocking;
    public Boolean isKeyOrdered;
    public Boolean isDistributed;
    public Boolean hasLocalKeyPartition;

    private boolean verify() {
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                if (f.get(this) != null) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not inspect setting: " + f.getName(), e);
            }
        }
        return true;
    }

    public StoreFeatures clone() {
        StoreFeatures newfeatures = new StoreFeatures();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            try {
                f.set(newfeatures, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not copy setting: " + f.getName(), e);
            }
        }
        return newfeatures;
    }

    public static StoreFeatures defaultFeature(boolean value) {
        StoreFeatures newfeatures = new StoreFeatures();
        for (Field f : StoreFeatures.class.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            try {
                f.set(newfeatures, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not read setting: " + f.getName(), e);
            }
        }
        return newfeatures;
    }

    public boolean supportsScan() {
        return this.supportsOrderedScan() || this.supportsUnorderedScan();
    }

    public boolean supportsUnorderedScan() {
        assert (this.verify());
        return this.supportsUnorderedScan;
    }

    public boolean supportsOrderedScan() {
        assert (this.verify());
        return this.supportsOrderedScan;
    }

    public boolean supportsMultiQuery() {
        assert (this.verify());
        return this.supportsMultiQuery;
    }

    public boolean supportsTransactions() {
        assert (this.verify());
        return this.supportsTransactions;
    }

    public boolean supportsConsistentKeyOperations() {
        assert (this.verify());
        return this.supportsConsistentKeyOperations;
    }

    public boolean supportsLocking() {
        assert (this.verify());
        return this.supportsLocking;
    }

    public boolean supportsBatchMutation() {
        assert (this.verify());
        return this.supportsBatchMutation;
    }

    public boolean isKeyOrdered() {
        assert (this.verify());
        return this.isKeyOrdered;
    }

    public boolean isDistributed() {
        assert (this.verify());
        return this.isDistributed;
    }

    public boolean hasLocalKeyPartition() {
        assert (this.verify());
        return this.hasLocalKeyPartition;
    }
}

