/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ConsistencyLevel;
import com.thinkaurelius.titan.diskstorage.util.TimeUtility;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;

public class StoreTxConfig {
    private final ConsistencyLevel consistency;
    private final String metricsPrefix;
    private Long timestamp = null;

    public StoreTxConfig() {
        this(ConsistencyLevel.DEFAULT, GraphDatabaseConfiguration.getSystemMetricsPrefix());
    }

    public StoreTxConfig(ConsistencyLevel consistency) {
        this(consistency, GraphDatabaseConfiguration.getSystemMetricsPrefix());
    }

    public StoreTxConfig(String metricsPrefix) {
        this(ConsistencyLevel.DEFAULT, metricsPrefix);
    }

    public StoreTxConfig(ConsistencyLevel consistency, String metricsPrefix) {
        Preconditions.checkNotNull((Object)((Object)consistency));
        this.consistency = consistency;
        this.metricsPrefix = metricsPrefix;
    }

    public StoreTxConfig setTimestamp() {
        this.timestamp = TimeUtility.INSTANCE.getApproxNSSinceEpoch();
        return this;
    }

    public StoreTxConfig setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public long getTimestamp() {
        if (this.timestamp == null) {
            this.setTimestamp();
        }
        assert (this.timestamp != null);
        return this.timestamp;
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }
}

