/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.BaseKeyColumnValueAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStoreManagerAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.util.BackendCompression;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStoreAdapter
extends BaseKeyColumnValueAdapter {
    private final Logger log = LoggerFactory.getLogger(CacheStoreAdapter.class);
    private static final int MAX_BYTE_LEN = 0x20000000;
    private static final int COLUMN_LEN_BYTES = 2;
    private static final int VALUE_LEN_BYTES = 4;
    private final CacheStore store;
    private final BackendCompression compression = BackendCompression.NO_COMPRESSION;
    private final int maxMutationRetries = 10;
    private final int mutationRetryWaitTimeMS = 50;
    private final CacheStoreManagerAdapter manager;

    public CacheStoreAdapter(CacheStore store, CacheStoreManagerAdapter manager) {
        super(store);
        this.store = store;
        this.manager = manager;
    }

    private final StaticBuffer decompress(StaticBuffer value) {
        if (value == null) {
            return null;
        }
        return this.compression.decompress(value);
    }

    private final StaticBuffer compress(StaticBuffer value) {
        if (value == null) {
            return null;
        }
        return this.compression.compress(value);
    }

    @Override
    public List<Entry> getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        StaticBuffer value = this.decompress(this.store.get(query.getKey(), txh));
        return new CacheEntryIterator(value, query).toList(query.getLimit());
    }

    @Override
    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws StorageException {
        return this.store.containsKey(key, txh);
    }

    @Override
    public void mutate(final StaticBuffer key, final List<Entry> additions, final List<StaticBuffer> deletions, final StoreTransaction txh) throws StorageException {
        if (additions.isEmpty() && deletions.isEmpty()) {
            return;
        }
        if (additions.size() > 1) {
            Collections.sort(additions);
        }
        int additionalLength = 0;
        for (Entry e : additions) {
            additionalLength += 6;
            additionalLength += e.getColumn().length();
            additionalLength += e.getValue().length();
        }
        if (deletions.size() > 1) {
            Collections.sort(deletions);
        }
        final int addLength = additionalLength;
        BackendOperation.execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                int vallen;
                int collen;
                StaticBuffer oldValueCompress = CacheStoreAdapter.this.store.get(key, txh);
                StaticBuffer oldValue = CacheStoreAdapter.this.decompress(oldValueCompress);
                int oldLen = oldValue == null ? 0 : oldValue.length();
                int newLen = oldLen + addLength;
                Preconditions.checkArgument((newLen < 0x20000000 ? 1 : 0) != 0, (String)"New allocation [%s] exceeded max value length [%s] ", (Object[])new Object[]{newLen, 0x20000000});
                ByteBuffer out = ByteBuffer.allocate(newLen);
                int addindex = 0;
                int delindex = 0;
                for (int oldindex = 0; oldindex < oldLen; oldindex += collen + vallen) {
                    collen = CacheStoreAdapter.fromUnsignedShort(oldValue.getShort(oldindex));
                    vallen = oldValue.getInt(oldindex += 2);
                    StaticBuffer col = oldValue.subrange(oldindex += 4, collen);
                    int cmp = -1;
                    boolean replace = false;
                    while (addindex < additions.size() && (cmp = col.compareTo(((Entry)additions.get(addindex)).getColumn())) >= 0) {
                        CacheStoreAdapter.insert((Entry)additions.get(addindex), out);
                        ++addindex;
                        if (cmp != 0) continue;
                        replace = true;
                    }
                    if (delindex < deletions.size() && col.compareTo(deletions.get(delindex)) == 0) {
                        ++delindex;
                    } else if (!replace) {
                        CacheStoreAdapter.insert(col, oldValue.subrange(oldindex + collen, vallen), out);
                    }
                    while (delindex < deletions.size() && col.compareTo(deletions.get(delindex)) >= 0) {
                        ++delindex;
                    }
                }
                while (addindex < additions.size()) {
                    CacheStoreAdapter.insert((Entry)additions.get(addindex), out);
                    ++addindex;
                }
                out.flip();
                if (!out.hasRemaining()) {
                    CacheStoreAdapter.this.store.delete(key, txh);
                } else {
                    StaticBuffer newValue = CacheStoreAdapter.this.compress(new StaticByteBuffer(out));
                    CacheStoreAdapter.this.store.replace(key, newValue, oldValueCompress, txh);
                }
                return null;
            }
        }, 10, 50L);
    }

    private static final void insert(Entry entry, ByteBuffer out) {
        CacheStoreAdapter.insert(entry.getColumn(), entry.getValue(), out);
    }

    private static final void insert(StaticBuffer col, StaticBuffer val, ByteBuffer out) {
        out.putShort(CacheStoreAdapter.toUnsignedShort(col.length()));
        Preconditions.checkArgument((val.length() >= 0 && val.length() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        out.putInt(val.length());
        CacheStoreAdapter.writeStaticBuffer(col, out);
        CacheStoreAdapter.writeStaticBuffer(val, out);
    }

    private static final void writeStaticBuffer(StaticBuffer buffer, ByteBuffer out) {
        for (int i = 0; i < buffer.length(); ++i) {
            out.put(buffer.getByte(i));
        }
    }

    private static final short toUnsignedShort(int value) {
        Preconditions.checkArgument((value >= 0 && value <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Value out of range: %s", (Object[])new Object[]{value});
        return (short)value;
    }

    private static final int fromUnsignedShort(short value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
        return value;
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws StorageException {
        return new CacheKeyIterator(this.store.getKeys(new KVUtil.RangeKeySelector(query.getKeyStart(), query.getKeyEnd()), txh), query);
    }

    @Override
    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws StorageException {
        return new CacheKeyIterator(this.store.getKeys(KeySelector.SelectAll, txh), query);
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        Preconditions.checkState((boolean)this.manager.getFeatures().supportsLocking(), (Object)"Store does not support transactions and hence cannot acquire locks");
    }

    private static class CacheEntryIterator
    implements RecordIterator<Entry> {
        private StaticBuffer value;
        private final SliceQuery slice;
        private int index = 0;
        private boolean foundStart = false;
        private Entry nextEntry;

        private CacheEntryIterator(StaticBuffer value, SliceQuery slice) {
            this.value = value;
            this.slice = slice;
            this.nextEntry = value == null ? null : this.getNextEntry();
        }

        public List<Entry> toList(int limit) throws StorageException {
            ArrayList<Entry> resultSet = new ArrayList<Entry>(Math.min(100, limit));
            while (this.hasNext() && resultSet.size() < limit) {
                resultSet.add(this.next());
            }
            this.close();
            return resultSet;
        }

        private Entry getNextEntry() {
            while (this.index < this.value.length()) {
                int collen = CacheStoreAdapter.fromUnsignedShort(this.value.getShort(this.index));
                this.index += 2;
                int vallen = this.value.getInt(this.index);
                this.index += 4;
                StaticBuffer col = this.value.subrange(this.index, collen);
                if (!this.foundStart) {
                    if (col.compareTo(this.slice.getSliceStart()) >= 0) {
                        this.foundStart = true;
                    } else {
                        this.index += collen + vallen;
                        continue;
                    }
                }
                if (this.foundStart && col.compareTo(this.slice.getSliceEnd()) >= 0) {
                    return null;
                }
                StaticBuffer val = this.value.subrange(this.index + collen, vallen);
                this.index += collen + vallen;
                return new StaticBufferEntry(col, val);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry result = this.nextEntry;
            this.nextEntry = this.getNextEntry();
            return result;
        }

        @Override
        public void close() {
            this.value = null;
            this.nextEntry = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CacheKeyIterator
    implements KeyIterator {
        private final SliceQuery slice;
        private final RecordIterator<KeyValueEntry> underlyingIter;
        private final Iterator<KeyValueEntry> iter;
        private KeyValueEntry entry;

        private CacheKeyIterator(RecordIterator<KeyValueEntry> iter, final SliceQuery slice) {
            this.slice = slice;
            this.underlyingIter = iter;
            this.iter = Iterators.filter(iter, (Predicate)new Predicate<KeyValueEntry>(){

                public boolean apply(KeyValueEntry input) {
                    int vallen;
                    int collen;
                    StaticBuffer value = input.getValue();
                    for (int index = 0; index < value.length(); index += collen + vallen) {
                        collen = CacheStoreAdapter.fromUnsignedShort(value.getShort(index));
                        vallen = value.getInt(index += 2);
                        StaticBuffer col = value.subrange(index += 4, collen);
                        if (col.compareTo(slice.getSliceStart()) < 0 || col.compareTo(slice.getSliceEnd()) >= 0) continue;
                        return true;
                    }
                    return false;
                }
            });
        }

        @Override
        public RecordIterator<Entry> getEntries() {
            Preconditions.checkState((this.entry != null ? 1 : 0) != 0);
            return new CacheEntryIterator(CacheStoreAdapter.this.decompress(this.entry.getValue()), this.slice);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public StaticBuffer next() {
            this.entry = this.iter.next();
            return this.entry.getKey();
        }

        @Override
        public void close() throws IOException {
            this.underlyingIter.close();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

