/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStoreAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.CacheStoreManager;
import java.util.HashMap;
import java.util.Map;

public class CacheStoreManagerAdapter
implements KeyColumnValueStoreManager {
    private final CacheStoreManager manager;
    private final Map<String, CacheStoreAdapter> stores;

    public CacheStoreManagerAdapter(CacheStoreManager manager) {
        this.manager = manager;
        this.stores = new HashMap<String, CacheStoreAdapter>();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.manager.getFeatures();
    }

    @Override
    public StoreTransaction beginTransaction(StoreTxConfig config) throws StorageException {
        return this.manager.beginTransaction(config);
    }

    @Override
    public void close() throws StorageException {
        this.manager.close();
    }

    @Override
    public void clearStorage() throws StorageException {
        this.manager.clearStorage();
    }

    @Override
    public synchronized CacheStoreAdapter openDatabase(String name) throws StorageException {
        if (!this.stores.containsKey(name)) {
            CacheStoreAdapter store = new CacheStoreAdapter(this.manager.openDatabase(name), this);
            this.stores.put(name, store);
        }
        return this.stores.get(name);
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        HashMap converted = new HashMap(mutations.size());
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeEntry : mutations.entrySet()) {
            CacheStoreAdapter store = this.openDatabase(storeEntry.getKey());
            Preconditions.checkNotNull((Object)store);
            for (Map.Entry<StaticBuffer, KCVMutation> entry : storeEntry.getValue().entrySet()) {
                StaticBuffer key = entry.getKey();
                KCVMutation mutation = entry.getValue();
                store.mutate(key, mutation.getAdditions(), mutation.getDeletions(), txh);
            }
        }
    }

    @Override
    public String getName() {
        return this.manager.getName();
    }
}

