/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreAdapter;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import java.util.HashMap;
import java.util.Map;

public class OrderedKeyValueStoreManagerAdapter
implements KeyColumnValueStoreManager {
    private final OrderedKeyValueStoreManager manager;
    private final ImmutableMap<String, Integer> keyLengths;
    private final Map<String, OrderedKeyValueStoreAdapter> stores;

    public OrderedKeyValueStoreManagerAdapter(OrderedKeyValueStoreManager manager) {
        this(manager, new HashMap<String, Integer>());
    }

    public OrderedKeyValueStoreManagerAdapter(OrderedKeyValueStoreManager manager, Map<String, Integer> keyLengths) {
        Preconditions.checkArgument((boolean)manager.getFeatures().isKeyOrdered(), (String)"Expected backing store to be ordered: %s", (Object[])new Object[]{manager});
        this.manager = manager;
        ImmutableMap.Builder mb = ImmutableMap.builder();
        if (keyLengths != null && !keyLengths.isEmpty()) {
            mb.putAll(keyLengths);
        }
        this.keyLengths = mb.build();
        this.stores = new HashMap<String, OrderedKeyValueStoreAdapter>();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.manager.getFeatures();
    }

    @Override
    public StoreTransaction beginTransaction(StoreTxConfig config) throws StorageException {
        return this.manager.beginTransaction(config);
    }

    @Override
    public void close() throws StorageException {
        this.manager.close();
    }

    @Override
    public void clearStorage() throws StorageException {
        this.manager.clearStorage();
    }

    @Override
    public synchronized OrderedKeyValueStoreAdapter openDatabase(String name) throws StorageException {
        if (!this.stores.containsKey(name)) {
            OrderedKeyValueStoreAdapter store = OrderedKeyValueStoreManagerAdapter.wrapKeyValueStore(this.manager.openDatabase(name), this.keyLengths);
            this.stores.put(name, store);
        }
        return this.stores.get(name);
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        HashMap<String, KVMutation> converted = new HashMap<String, KVMutation>(mutations.size());
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeEntry : mutations.entrySet()) {
            OrderedKeyValueStoreAdapter store = this.openDatabase(storeEntry.getKey());
            Preconditions.checkNotNull((Object)store);
            KVMutation mut = new KVMutation();
            for (Map.Entry<StaticBuffer, KCVMutation> entry : storeEntry.getValue().entrySet()) {
                StaticBuffer key = entry.getKey();
                KCVMutation mutation = entry.getValue();
                if (mutation.hasAdditions()) {
                    for (Entry addition : mutation.getAdditions()) {
                        mut.addition(new KeyValueEntry(store.concatenate(key, addition.getColumn()), addition.getValue()));
                    }
                }
                if (!mutation.hasDeletions()) continue;
                for (StaticBuffer column : mutation.getDeletions()) {
                    mut.deletion(store.concatenate(key, column));
                }
            }
            converted.put(storeEntry.getKey(), mut);
        }
        this.manager.mutateMany(converted, txh);
    }

    private static final OrderedKeyValueStoreAdapter wrapKeyValueStore(OrderedKeyValueStore store, Map<String, Integer> keyLengths) {
        String name = store.getName();
        if (keyLengths.containsKey(name)) {
            int keyLength = keyLengths.get(name);
            Preconditions.checkArgument((keyLength > 0 ? 1 : 0) != 0);
            return new OrderedKeyValueStoreAdapter(store, keyLength);
        }
        return new OrderedKeyValueStoreAdapter(store);
    }

    @Override
    public String getName() {
        return this.manager.getName();
    }
}

