/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediator;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediators;
import com.thinkaurelius.titan.diskstorage.locking.LockStatus;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.LockerState;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLockerSerializer;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import com.thinkaurelius.titan.diskstorage.util.TimeUtility;
import com.thinkaurelius.titan.diskstorage.util.TimestampProvider;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocker<S extends LockStatus>
implements Locker {
    protected final StaticBuffer rid;
    protected final TimestampProvider times;
    protected final ConsistentKeyLockerSerializer serializer;
    protected final LocalLockMediator<StoreTransaction> llm;
    protected final LockerState<S> lockState;
    protected final long lockExpireNS;
    protected final Logger log;
    private static final String M_LOCKS = "locks";
    private static final String M_WRITE = "write";
    private static final String M_CHECK = "check";
    private static final String M_DELETE = "delete";
    private static final String M_CALLS = "calls";
    private static final String M_EXCEPTIONS = "exceptions";

    public AbstractLocker(StaticBuffer rid, TimestampProvider times, ConsistentKeyLockerSerializer serializer, LocalLockMediator<StoreTransaction> llm, LockerState<S> lockState, long lockExpireNS, Logger log) {
        this.rid = rid;
        this.times = times;
        this.serializer = serializer;
        this.llm = llm;
        this.lockState = lockState;
        this.lockExpireNS = lockExpireNS;
        this.log = log;
    }

    protected abstract S writeSingleLock(KeyColumn var1, StoreTransaction var2) throws Throwable;

    protected abstract void checkSingleLock(KeyColumn var1, S var2, StoreTransaction var3) throws Throwable;

    protected abstract void deleteSingleLock(KeyColumn var1, S var2, StoreTransaction var3) throws Throwable;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeLock(KeyColumn lockID, StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        if (null != tx.getConfiguration().getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_WRITE, M_CALLS).inc();
        }
        if (this.lockState.has(tx, lockID)) {
            this.log.debug("Transaction {} already wrote lock on {}", (Object)tx, (Object)lockID);
            return;
        }
        if (!this.lockLocally(lockID, tx)) {
            throw new PermanentLockingException("Local lock contention");
        }
        boolean ok = false;
        try {
            S stat = this.writeSingleLock(lockID, tx);
            this.lockLocally(lockID, stat.getExpirationTimestamp(TimeUnit.NANOSECONDS), tx);
            this.lockState.take(tx, lockID, stat);
            return;
        }
        catch (TemporaryStorageException tse) {
            try {
                throw new TemporaryLockingException(tse);
                catch (AssertionError ae) {
                    ok = true;
                    throw ae;
                }
                catch (Throwable t) {
                    throw new PermanentLockingException(t);
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.unlockLocally(lockID, tx);
                    if (null != tx.getConfiguration().getMetricsPrefix()) {
                        MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_WRITE, M_EXCEPTIONS).inc();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkLocks(StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        Map<KeyColumn, S> m;
        if (null != tx.getConfiguration().getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_CHECK, M_CALLS).inc();
        }
        if ((m = this.lockState.getLocksForTx(tx)).isEmpty()) {
            return;
        }
        boolean ok = false;
        try {
            for (KeyColumn kc : m.keySet()) {
                this.checkSingleLock(kc, (LockStatus)m.get(kc), tx);
            }
            ok = true;
            if (ok) return;
            if (null == tx.getConfiguration().getMetricsPrefix()) return;
        }
        catch (InterruptedException e) {
            try {
                throw new TemporaryLockingException(e);
                catch (TemporaryStorageException tse) {
                    throw new TemporaryLockingException(tse);
                }
                catch (AssertionError ae) {
                    throw ae;
                }
                catch (Throwable t) {
                    throw new PermanentLockingException(t);
                }
            }
            catch (Throwable throwable) {
                if (ok) throw throwable;
                if (null == tx.getConfiguration().getMetricsPrefix()) throw throwable;
                MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_CHECK, M_CALLS).inc();
                throw throwable;
            }
        }
        MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_CHECK, M_CALLS).inc();
    }

    @Override
    public void deleteLocks(StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        if (null != tx.getConfiguration().getMetricsPrefix()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_DELETE, M_CALLS).inc();
        }
        Map<KeyColumn, S> m = this.lockState.getLocksForTx(tx);
        Iterator<KeyColumn> iter = m.keySet().iterator();
        while (iter.hasNext()) {
            KeyColumn kc;
            block5: {
                kc = iter.next();
                LockStatus ls = (LockStatus)m.get(kc);
                try {
                    this.deleteSingleLock(kc, ls, tx);
                }
                catch (AssertionError ae) {
                    throw ae;
                }
                catch (Throwable t) {
                    this.log.error("Exception while deleting lock on " + kc, t);
                    if (null == tx.getConfiguration().getMetricsPrefix()) break block5;
                    MetricManager.INSTANCE.getCounter(tx.getConfiguration().getMetricsPrefix(), M_LOCKS, M_DELETE, M_CALLS).inc();
                }
            }
            this.llm.unlock(kc, tx);
            iter.remove();
        }
    }

    private boolean lockLocally(KeyColumn lockID, StoreTransaction tx) {
        return this.lockLocally(lockID, this.times.getApproxNSSinceEpoch() + this.lockExpireNS, tx);
    }

    private boolean lockLocally(KeyColumn lockID, long expireNS, StoreTransaction tx) {
        return this.llm.lock(lockID, tx, expireNS, TimeUnit.NANOSECONDS);
    }

    private void unlockLocally(KeyColumn lockID, StoreTransaction txh) {
        this.llm.unlock(lockID, txh);
    }

    public static abstract class Builder<S, B extends Builder<S, B>> {
        protected StaticBuffer rid = new StaticByteBuffer(DistributedStoreManager.getRid((Configuration)new BaseConfiguration()));
        protected TimestampProvider times = TimeUtility.INSTANCE;
        protected ConsistentKeyLockerSerializer serializer = new ConsistentKeyLockerSerializer();
        protected LocalLockMediator<StoreTransaction> llm = null;
        protected LockerState<S> lockState = new LockerState();
        protected long lockExpireNS = TimeUnit.NANOSECONDS.convert(300000L, TimeUnit.MILLISECONDS);
        protected Logger log = LoggerFactory.getLogger(AbstractLocker.class);

        protected abstract B self();

        public B rid(StaticBuffer rid) {
            this.rid = rid;
            return this.self();
        }

        public B times(TimestampProvider times) {
            this.times = times;
            return this.self();
        }

        public B serializer(ConsistentKeyLockerSerializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        public B mediator(LocalLockMediator<StoreTransaction> mediator) {
            this.llm = mediator;
            return this.self();
        }

        public B mediatorName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.mediator(LocalLockMediators.INSTANCE.get(name));
            return this.self();
        }

        public B logger(Logger log) {
            this.log = log;
            return this.self();
        }

        public B lockExpireNS(long exp, TimeUnit unit) {
            this.lockExpireNS = TimeUnit.NANOSECONDS.convert(exp, unit);
            return this.self();
        }

        public B internalState(LockerState<S> state) {
            this.lockState = state;
            return this.self();
        }

        protected void preBuild() {
            if (null == this.llm) {
                this.llm = this.getDefaultMediator();
            }
        }

        protected abstract LocalLockMediator<StoreTransaction> getDefaultMediator();
    }
}

