/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking;

import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.diskstorage.util.TimeUtility;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLockMediator<T> {
    private static final Logger log = LoggerFactory.getLogger(LocalLockMediator.class);
    private final String name;
    private final ConcurrentHashMap<KeyColumn, AuditRecord<T>> locks = new ConcurrentHashMap();

    public LocalLockMediator(String name) {
        this.name = name;
        assert (null != this.name);
    }

    public boolean lock(KeyColumn kc, T requestor, long expires, TimeUnit tu) {
        assert (null != kc);
        assert (null != requestor);
        AuditRecord audit = new AuditRecord(requestor, TimeUnit.NANOSECONDS.convert(expires, tu));
        AuditRecord inmap = this.locks.putIfAbsent(kc, audit);
        boolean success = false;
        if (null == inmap) {
            if (log.isTraceEnabled()) {
                log.trace("New local lock created: {} namespace={} txn={}", new Object[]{kc, this.name, requestor});
            }
            success = true;
        } else if (inmap.equals(audit)) {
            success = this.locks.replace(kc, inmap, audit);
            if (log.isTraceEnabled()) {
                if (success) {
                    log.trace("Updated local lock expiration: {} namespace={} txn={} oldexp={} newexp={}", new Object[]{kc, this.name, requestor, inmap.expires, audit.expires});
                } else {
                    log.trace("Failed to update local lock expiration: {} namespace={} txn={} oldexp={} newexp={}", new Object[]{kc, this.name, requestor, inmap.expires, audit.expires});
                }
            }
        } else if (inmap.expires <= TimeUtility.INSTANCE.getApproxNSSinceEpoch()) {
            success = this.locks.replace(kc, inmap, audit);
            if (log.isTraceEnabled()) {
                log.trace("Discarding expired lock: {} namespace={} txn={} expired={}", new Object[]{kc, this.name, inmap.holder, inmap.expires});
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Local lock failed: {} namespace={} txn={} (already owned by {})", new Object[]{kc, this.name, requestor, inmap});
        }
        return success;
    }

    public boolean unlock(KeyColumn kc, T requestor) {
        if (!this.locks.containsKey(kc)) {
            log.error("Local unlock failed: no locks found for {}", (Object)kc);
            return false;
        }
        AuditRecord unlocker = new AuditRecord(requestor, 0L);
        AuditRecord<T> holder = this.locks.get(kc);
        if (!holder.equals(unlocker)) {
            log.error("Local unlock of {} by {} failed: it is held by {}", new Object[]{kc, unlocker, holder});
            return false;
        }
        boolean removed = this.locks.remove(kc, unlocker);
        if (removed) {
            if (log.isTraceEnabled()) {
                log.trace("Local unlock succeeded: {} namespace={} txn={}", new Object[]{kc, this.name, requestor});
            }
        } else {
            log.warn("Local unlock warning: lock record for {} disappeared during removal; this suggests the lock either expired while we were removing it, or that it was erroneously unlocked multiple times.", (Object)kc);
        }
        return true;
    }

    public String toString() {
        return "LocalLockMediator [" + this.name + ",  ~" + this.locks.size() + " current locks]";
    }

    private static class AuditRecord<T> {
        private final T holder;
        private final long expires;
        private int hashCode;

        private AuditRecord(T holder, long expires) {
            this.holder = holder;
            this.expires = expires;
        }

        public int hashCode() {
            if (0 == this.hashCode) {
                this.hashCode = this.holder.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AuditRecord other = (AuditRecord)obj;
            return !(this.holder == null ? other.holder != null : !this.holder.equals(other.holder));
        }

        public String toString() {
            return "AuditRecord [txn=" + this.holder + ", expires=" + this.expires + "]";
        }
    }
}

