/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.thinkaurelius.titan.diskstorage.locking.LockStatus;
import java.util.concurrent.TimeUnit;

public class ConsistentKeyLockStatus
implements LockStatus {
    private long writeNS;
    private long expireNS;
    private boolean checked;

    public ConsistentKeyLockStatus(long writeTimestamp, TimeUnit writeUnits, long expireTimestamp, TimeUnit expireUnits) {
        this.writeNS = TimeUnit.NANOSECONDS.convert(writeTimestamp, writeUnits);
        this.expireNS = TimeUnit.NANOSECONDS.convert(expireTimestamp, expireUnits);
        this.checked = false;
    }

    @Override
    public long getExpirationTimestamp(TimeUnit tu) {
        return tu.convert(this.expireNS, TimeUnit.NANOSECONDS);
    }

    public long getWriteTimestamp(TimeUnit tu) {
        return tu.convert(this.writeNS, TimeUnit.NANOSECONDS);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked() {
        this.checked = true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checked ? 1231 : 1237);
        result = 31 * result + (int)(this.expireNS ^ this.expireNS >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsistentKeyLockStatus other = (ConsistentKeyLockStatus)obj;
        if (this.checked != other.checked) {
            return false;
        }
        return this.expireNS == other.expireNS;
    }
}

