/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingStore
implements KeyColumnValueStore {
    public static final String LOCAL_LOCK_MEDIATOR_PREFIX_KEY = "local-lock-mediator-prefix";
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingStore.class);
    final KeyColumnValueStore dataStore;
    final Locker locker;

    public ExpectedValueCheckingStore(KeyColumnValueStore dataStore, Locker locker) {
        Preconditions.checkNotNull((Object)dataStore);
        this.dataStore = dataStore;
        this.locker = locker;
    }

    public KeyColumnValueStore getDataStore() {
        return this.dataStore;
    }

    private StoreTransaction getBaseTx(StoreTransaction txh) {
        Preconditions.checkNotNull((Object)txh);
        Preconditions.checkArgument((boolean)(txh instanceof ExpectedValueCheckingTransaction));
        return ((ExpectedValueCheckingTransaction)txh).getBaseTransaction();
    }

    @Override
    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws StorageException {
        return this.dataStore.containsKey(key, this.getBaseTx(txh));
    }

    @Override
    public List<Entry> getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getSlice(query, this.getBaseTx(txh));
    }

    @Override
    public List<List<Entry>> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getSlice(keys, query, this.getBaseTx(txh));
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        ExpectedValueCheckingTransaction tx;
        if (this.locker != null && !(tx = (ExpectedValueCheckingTransaction)txh).isMutationStarted()) {
            tx.mutationStarted();
            this.locker.checkLocks(tx.getConsistentTransaction());
            tx.checkExpectedValues();
        }
        this.dataStore.mutate(key, additions, deletions, this.getBaseTx(txh));
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        if (this.locker != null) {
            ExpectedValueCheckingTransaction tx = (ExpectedValueCheckingTransaction)txh;
            if (tx.isMutationStarted()) {
                throw new PermanentLockingException("Attempted to obtain a lock after mutations had been persisted");
            }
            KeyColumn lockID = new KeyColumn(key, column);
            log.debug("Attempting to acquireLock on {} ev={}", (Object)lockID, (Object)expectedValue);
            this.locker.writeLock(lockID, tx.getConsistentTransaction());
            tx.storeExpectedValue(this, lockID, expectedValue);
        } else {
            this.dataStore.acquireLock(key, column, expectedValue, this.getBaseTx(txh));
        }
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getKeys(query, this.getBaseTx(txh));
    }

    @Override
    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getKeys(query, this.getBaseTx(txh));
    }

    @Override
    public StaticBuffer[] getLocalKeyPartition() throws StorageException {
        return this.dataStore.getLocalKeyPartition();
    }

    @Override
    public String getName() {
        return this.dataStore.getName();
    }

    @Override
    public void close() throws StorageException {
        this.dataStore.close();
    }

    void deleteLocks(ExpectedValueCheckingTransaction tx) throws StorageException {
        this.locker.deleteLocks(tx.getConsistentTransaction());
    }
}

