/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendOperation {
    private static final Logger log = LoggerFactory.getLogger(BackendOperation.class);
    private static final long BASE_REATTEMPT_TIME_MS = 50L;
    private static final double WAITTIME_PERTURBATION_PERCENTAGE = 0.5;
    private static final double WAITTIME_PERTURBATION_PERCENTAGE_HALF = 0.25;

    public static final <V> V execute(Callable<V> exe, long maxTimeMS) throws TitanException {
        long waitTime = 50L;
        long maxTime = System.currentTimeMillis() + maxTimeMS;
        StorageException lastException = null;
        do {
            try {
                return exe.call();
            }
            catch (StorageException e) {
                if (e instanceof TemporaryStorageException) {
                    lastException = e;
                }
                throw new TitanException("Permanent exception during backend operation", e);
            }
            catch (Throwable e) {
                throw new TitanException("Unexpected exception during backend operation", e);
            }
            Preconditions.checkNotNull((Object)lastException);
            if (System.currentTimeMillis() + waitTime < maxTime) {
                log.info("Temporary storage exception during backend operation. Attempting backoff retry", (Object)exe.toString(), (Object)lastException);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException r) {
                    throw new TitanException("Interrupted while waiting to retry failed storage operation", r);
                }
            }
            waitTime *= 2L;
        } while (System.currentTimeMillis() < maxTime);
        throw new TitanException("Could not successfully complete backend operation due to repeated temporary exceptions after " + maxTimeMS + " ms", lastException);
    }

    public static final <V> V execute(Callable<V> exe, int maxRetryAttempts, long retryWaittime) throws TitanException {
        Preconditions.checkArgument((maxRetryAttempts > 0 ? 1 : 0) != 0, (Object)"Retry attempts must be positive");
        Preconditions.checkArgument((retryWaittime >= 0L ? 1 : 0) != 0, (Object)"Retry wait time must be non-negative");
        int retryAttempts = 0;
        StorageException lastException = null;
        do {
            try {
                return exe.call();
            }
            catch (StorageException e) {
                if (e instanceof TemporaryStorageException) {
                    lastException = e;
                }
                throw new TitanException("Permanent exception during backend operation", e);
            }
            catch (Throwable e) {
                throw new TitanException("Unexpected exception during backend operation", e);
            }
            Preconditions.checkNotNull((Object)lastException);
            if (++retryAttempts >= maxRetryAttempts) continue;
            long waitTime = Math.round((double)retryWaittime + (Math.random() * 0.5 - 0.25) * (double)retryWaittime);
            Preconditions.checkArgument((waitTime >= 0L ? 1 : 0) != 0, (String)"Invalid wait time: %s", (Object[])new Object[]{waitTime});
            log.info("Temporary storage exception during backend operation [{}]. Attempting incremental retry", (Object)exe.toString(), (Object)lastException);
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException r) {
                throw new TitanException("Interrupted while waiting to retry failed backend operation", r);
            }
        } while (retryAttempts < maxRetryAttempts);
        throw new TitanException("Could not successfully complete backend operation due to repeated temporary exceptions after " + maxRetryAttempts + " attempts", lastException);
    }

    public static <R> R execute(Transactional<R> exe, TransactionalProvider provider) throws StorageException {
        StoreTransaction txh = null;
        try {
            txh = provider.openTx();
            R r = exe.call(txh);
            return r;
        }
        catch (StorageException e) {
            if (txh != null) {
                txh.rollback();
            }
            txh = null;
            throw e;
        }
        finally {
            if (txh != null) {
                txh.commit();
            }
        }
    }

    public static interface TransactionalProvider {
        public StoreTransaction openTx() throws StorageException;
    }

    public static interface Transactional<R> {
        public R call(StoreTransaction var1) throws StorageException;
    }
}

