/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.Hex;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferUtil {
    public static final int longSize = 8;
    public static final int intSize = 4;

    public static final ByteBuffer getIntByteBuffer(int id) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(id);
        buffer.flip();
        return buffer;
    }

    public static final StaticBuffer getIntBuffer(int id) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(id);
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 4 ? 1 : 0) != 0);
        return new StaticArrayBuffer(arr);
    }

    public static final StaticBuffer getIntBuffer(int[] ids) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * ids.length);
        for (int i = 0; i < ids.length; ++i) {
            buffer.putInt(ids[i]);
        }
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 4 * ids.length ? 1 : 0) != 0);
        return new StaticArrayBuffer(arr);
    }

    public static final StaticBuffer getLongBuffer(long id) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(id);
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 8 ? 1 : 0) != 0);
        return new StaticArrayBuffer(arr);
    }

    public static final ByteBuffer getLongByteBuffer(long id) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(id);
        buffer.flip();
        return buffer;
    }

    public static final ByteBuffer getLongByteBuffer(long[] ids) {
        ByteBuffer buffer = ByteBuffer.allocate(8 * ids.length);
        for (int i = 0; i < ids.length; ++i) {
            buffer.putLong(ids[i]);
        }
        buffer.flip();
        return buffer;
    }

    public static final ByteBuffer nextBiggerBuffer(ByteBuffer buffer) {
        int len = buffer.remaining();
        int pos = buffer.position();
        ByteBuffer next = ByteBuffer.allocate(len);
        boolean carry = true;
        for (int i = len - 1; i >= 0; --i) {
            byte b = buffer.get(i + pos);
            if (carry && (b = (byte)(b + 1)) != 0) {
                carry = false;
            }
            next.put(i, b);
        }
        Preconditions.checkArgument((!carry ? 1 : 0) != 0, (Object)"Buffer overflow");
        next.position(0);
        next.limit(len);
        return next;
    }

    public static final StaticBuffer nextBiggerBuffer(StaticBuffer buffer) {
        int len = buffer.length();
        byte[] next = new byte[len];
        boolean carry = true;
        for (int i = len - 1; i >= 0; --i) {
            byte b = buffer.getByte(i);
            if (carry && (b = (byte)(b + 1)) != 0) {
                carry = false;
            }
            next[i] = b;
        }
        Preconditions.checkArgument((!carry ? 1 : 0) != 0, (Object)"Buffer overflow");
        return new StaticArrayBuffer(next);
    }

    public static final ByteBuffer zeroByteBuffer(int len) {
        ByteBuffer res = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            res.put((byte)0);
        }
        res.flip();
        return res;
    }

    public static final ByteBuffer oneByteBuffer(int len) {
        ByteBuffer res = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            res.put((byte)-1);
        }
        res.flip();
        return res;
    }

    public static final StaticBuffer fillBuffer(int len, byte value) {
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = value;
        }
        return new StaticArrayBuffer(res);
    }

    public static final StaticBuffer oneBuffer(int len) {
        return ByteBufferUtil.fillBuffer(len, (byte)-1);
    }

    public static final StaticBuffer zeroBuffer(int len) {
        return ByteBufferUtil.fillBuffer(len, (byte)0);
    }

    public static final StaticBuffer emptyBuffer() {
        return ByteBufferUtil.fillBuffer(0, (byte)0);
    }

    public static final boolean isSmallerThan(ByteBuffer a, ByteBuffer b) {
        return ByteBufferUtil.compare(a, b) < 0;
    }

    public static boolean isSmallerOrEqualThan(ByteBuffer a, ByteBuffer b) {
        return ByteBufferUtil.compare(a, b) <= 0;
    }

    public static boolean isSmallerThan(StaticBuffer a, StaticBuffer b) {
        return ByteBufferUtil.compare(a, b) < 0;
    }

    public static boolean isSmallerOrEqualThan(StaticBuffer a, StaticBuffer b) {
        return ByteBufferUtil.compare(a, b) <= 0;
    }

    public static final int compare(ByteBuffer b1, ByteBuffer b2) {
        if (b1 == b2) {
            return 0;
        }
        int p1 = b1.position();
        for (int p2 = b2.position(); p1 < b1.limit() || p2 < b2.limit(); ++p1, ++p2) {
            if (p1 >= b1.limit()) {
                return -1;
            }
            if (p2 >= b2.limit()) {
                return 1;
            }
            int cmp = ByteBufferUtil.compare(b1.get(p1), b2.get(p2));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static int compare(byte c1, byte c2) {
        int a = c1 & 0xFF;
        int b = c2 & 0xFF;
        return a - b;
    }

    public static int compare(StaticBuffer b1, StaticBuffer b2) {
        int j;
        if (b1 == b2) {
            return 0;
        }
        if (b1 instanceof StaticArrayBuffer && b2 instanceof StaticArrayBuffer) {
            return ((StaticArrayBuffer)b1).compareTo((StaticArrayBuffer)b2);
        }
        int i = 0;
        for (j = 0; i < b1.length() && j < b2.length(); ++i, ++j) {
            int cmp = ByteBufferUtil.compare(b1.getByte(i), b2.getByte(j));
            if (cmp == 0) continue;
            return cmp;
        }
        return b1.length() - i + 1 - (b2.length() - j + 1);
    }

    public static final int hashcode(ByteBuffer b) {
        int result = 17;
        for (int i = b.position(); i < b.limit(); ++i) {
            result = 31 * result + b.get(i);
        }
        return result;
    }

    public static final int hashcode(StaticBuffer b) {
        int result = 17;
        for (int i = 0; i < b.length(); ++i) {
            result = 31 * result + b.getByte(i);
        }
        return result;
    }

    public static final boolean equals(ByteBuffer b1, ByteBuffer b2) {
        int p2;
        if (b1.remaining() != b2.remaining()) {
            return false;
        }
        int p1 = b1.position();
        for (p2 = b2.position(); p1 < b1.limit() && p2 < b2.limit(); ++p1, ++p2) {
            if (b1.get(p1) == b2.get(p2)) continue;
            return false;
        }
        assert (p1 == b1.limit() && p2 == b2.limit());
        return true;
    }

    public static final boolean equals(StaticBuffer b1, StaticBuffer b2) {
        if (b1.length() != b2.length()) {
            return false;
        }
        for (int i = 0; i < b1.length(); ++i) {
            if (b1.getByte(i) == b2.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public static final String toString(ByteBuffer b, String separator) {
        StringBuilder s = new StringBuilder();
        for (int i = b.position(); i < b.limit(); ++i) {
            byte c;
            if (i > b.position()) {
                s.append(separator);
            }
            if ((c = b.get(i)) >= 0) {
                s.append(c);
                continue;
            }
            s.append(256 + c);
        }
        return s.toString();
    }

    public static final String toString(StaticBuffer b, String separator) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < b.length(); ++i) {
            byte c;
            if (i > 0) {
                s.append(separator);
            }
            if ((c = b.getByte(i)) >= 0) {
                s.append(c);
                continue;
            }
            s.append(256 + c);
        }
        return s.toString();
    }

    public static final String toBitString(ByteBuffer b, String byteSeparator) {
        StringBuilder s = new StringBuilder();
        for (int i = b.position(); i < b.limit(); ++i) {
            byte n = b.get(i);
            String bn = Integer.toBinaryString(n);
            if (bn.length() > 8) {
                bn = bn.substring(bn.length() - 8);
            } else if (bn.length() < 8) {
                while (bn.length() < 8) {
                    bn = "0" + bn;
                }
            }
            s.append(bn).append(byteSeparator);
        }
        return s.toString();
    }

    public static String bytesToHex(ByteBuffer bytes) {
        int offset = bytes.position();
        int size = bytes.remaining();
        char[] c = new char[size * 2];
        for (int i = 0; i < size; ++i) {
            byte bint = bytes.get(i + offset);
            c[i * 2] = Hex.byteToChar[(bint & 0xF0) >> 4];
            c[1 + i * 2] = Hex.byteToChar[bint & 0xF];
        }
        return Hex.wrapCharArray(c);
    }

    public static byte[] getArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int boff = buffer.arrayOffset() + buffer.position();
            return Arrays.copyOfRange(buffer.array(), boff, boff + length);
        }
        byte[] bytes = new byte[length];
        int pos = 0;
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            bytes[pos] = buffer.get(i);
            ++pos;
        }
        Preconditions.checkArgument((pos == length ? 1 : 0) != 0);
        return bytes;
    }
}

