/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.ReadArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import java.nio.ByteBuffer;

public class ReadByteBuffer
extends StaticByteBuffer
implements ReadBuffer {
    private transient int position = 0;

    public ReadByteBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    public ReadByteBuffer(byte[] bytes) {
        super(bytes);
    }

    public ReadByteBuffer(ReadByteBuffer buffer) {
        super(buffer);
        this.position = buffer.position;
    }

    private int updatePos(int update) {
        int pos = this.position;
        this.position += update;
        return pos;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.length();
    }

    @Override
    public void movePosition(int delta) {
        int newPosition = this.position + delta;
        assert (newPosition >= -1 && newPosition <= this.length());
        this.position = newPosition;
    }

    @Override
    public byte getByte() {
        return super.getByte(this.updatePos(1));
    }

    @Override
    public short getShort() {
        return super.getShort(this.updatePos(2));
    }

    @Override
    public int getInt() {
        return super.getInt(this.updatePos(4));
    }

    @Override
    public long getLong() {
        return super.getLong(this.updatePos(8));
    }

    @Override
    public char getChar() {
        return super.getChar(this.updatePos(2));
    }

    @Override
    public float getFloat() {
        return super.getFloat(this.updatePos(4));
    }

    @Override
    public double getDouble() {
        return super.getDouble(this.updatePos(8));
    }

    @Override
    public ByteBuffer asRelativeByteBuffer() {
        ByteBuffer rb = super.asByteBuffer();
        rb.position(rb.position() + this.position);
        return rb;
    }

    @Override
    public <T> T asRelative(final StaticBuffer.Factory<T> factory) {
        if (this.position == 0) {
            return super.as(factory);
        }
        return super.as(new StaticBuffer.Factory<T>(){

            @Override
            public T get(byte[] array, int offset, int limit) {
                return factory.get(array, offset + ReadByteBuffer.this.position, limit);
            }
        });
    }

    @Override
    public ReadBuffer invert() {
        byte[] newvalues = new byte[super.length()];
        for (int i = 0; i < newvalues.length; ++i) {
            newvalues[i] = ~super.getByte(i);
        }
        ReadArrayBuffer newread = new ReadArrayBuffer(newvalues);
        newread.movePosition(this.position);
        return newread;
    }
}

