/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.ReadArrayBuffer;
import java.nio.ByteBuffer;

public class StaticArrayBuffer
implements StaticBuffer {
    private final byte[] array;
    private final int offset;
    private final int limit;

    public StaticArrayBuffer(byte[] array, int offset, int limit) {
        assert (array != null);
        assert (offset >= 0 && offset <= limit);
        assert (limit <= array.length);
        this.array = array;
        this.offset = offset;
        this.limit = limit;
    }

    public StaticArrayBuffer(byte[] array, int limit) {
        this(array, 0, limit);
    }

    public StaticArrayBuffer(byte[] array) {
        this(array, 0, array.length);
    }

    public StaticArrayBuffer(StaticArrayBuffer buffer) {
        this(buffer.array, buffer.offset, buffer.limit);
    }

    private int require(int position, int size) {
        int base = position + this.offset;
        assert (base + size <= this.limit);
        return base;
    }

    private byte getByteDirect(int position) {
        return this.array[position];
    }

    @Override
    public int length() {
        return this.limit - this.offset;
    }

    @Override
    public StaticBuffer subrange(int position, int length) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset + position + length <= this.limit ? 1 : 0) != 0);
        return new StaticArrayBuffer(this.array, this.offset + position, this.offset + position + length);
    }

    @Override
    public ReadBuffer asReadBuffer() {
        return new ReadArrayBuffer(this);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.array, this.offset, this.limit - this.offset);
    }

    @Override
    public <T> T as(StaticBuffer.Factory<T> factory) {
        return factory.get(this.array, this.offset, this.limit);
    }

    @Override
    public byte getByte(int position) {
        return this.getByteDirect(this.require(position, 1));
    }

    @Override
    public short getShort(int position) {
        int base = this.require(position, 2);
        return (short)((this.getByteDirect(base++) & 0xFF) << 8 | this.getByteDirect(base++) & 0xFF);
    }

    @Override
    public int getInt(int position) {
        int base = this.require(position, 4);
        return (this.getByteDirect(base) & 0xFF) << 24 | (this.getByteDirect(base + 1) & 0xFF) << 16 | (this.getByteDirect(base + 2) & 0xFF) << 8 | this.getByteDirect(base + 3) & 0xFF;
    }

    @Override
    public long getLong(int position) {
        int base = this.require(position, 8);
        return (long)this.getByteDirect(base++) << 56 | (long)(this.getByteDirect(base++) & 0xFF) << 48 | (long)(this.getByteDirect(base++) & 0xFF) << 40 | (long)(this.getByteDirect(base++) & 0xFF) << 32 | (long)(this.getByteDirect(base++) & 0xFF) << 24 | (long)((this.getByteDirect(base++) & 0xFF) << 16) | (long)((this.getByteDirect(base++) & 0xFF) << 8) | (long)(this.getByteDirect(base++) & 0xFF);
    }

    @Override
    public char getChar(int position) {
        int base = this.require(position, 2);
        return (char)((this.getByteDirect(base++) & 0xFF) << 8 | this.getByteDirect(base++) & 0xFF);
    }

    @Override
    public float getFloat(int position) {
        return Float.intBitsToFloat(this.getInt(position));
    }

    @Override
    public double getDouble(int position) {
        return Double.longBitsToDouble(this.getLong(position));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StaticBuffer)) {
            return false;
        }
        return ByteBufferUtil.equals(this, (StaticBuffer)o);
    }

    public int hashCode() {
        return ByteBufferUtil.hashcode(this);
    }

    public String toString() {
        return ByteBufferUtil.toString(this, "-");
    }

    @Override
    public int compareTo(StaticBuffer other) {
        return other instanceof StaticArrayBuffer ? this.compareTo((StaticArrayBuffer)other) : ByteBufferUtil.compare(this, other);
    }

    @Override
    public int compareTo(StaticArrayBuffer other) {
        return StaticArrayBuffer.compareTo(this.array, this.offset, this.limit, other.array, other.offset, other.limit);
    }

    private static int compareTo(byte[] buffer1, int offset1, int end1, byte[] buffer2, int offset2, int end2) {
        int length1 = end1 - offset1;
        int length2 = end2 - offset2;
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }
}

