/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.ReadByteBuffer;
import java.nio.ByteBuffer;

public class StaticByteBuffer
implements StaticBuffer {
    private final ByteBuffer b;

    public StaticByteBuffer(ByteBuffer buffer) {
        Preconditions.checkNotNull((Object)buffer);
        this.b = buffer;
    }

    public StaticByteBuffer(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public StaticByteBuffer(StaticByteBuffer buffer) {
        this(buffer.b);
    }

    protected final int pos(int position) {
        return this.b.position() + position;
    }

    @Override
    public int length() {
        return this.b.limit() - this.b.position();
    }

    @Override
    public byte getByte(int position) {
        return this.b.get(this.pos(position));
    }

    @Override
    public short getShort(int position) {
        return this.b.getShort(this.pos(position));
    }

    @Override
    public int getInt(int position) {
        return this.b.getInt(this.pos(position));
    }

    @Override
    public long getLong(int position) {
        return this.b.getLong(this.pos(position));
    }

    @Override
    public char getChar(int position) {
        return this.b.getChar(this.pos(position));
    }

    @Override
    public float getFloat(int position) {
        return this.b.getFloat(this.pos(position));
    }

    @Override
    public double getDouble(int position) {
        return this.b.getDouble(this.pos(position));
    }

    @Override
    public StaticBuffer subrange(int position, int length) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.b.position() + position + length <= this.b.limit() ? 1 : 0) != 0, (String)"%s + %s + %s <= %s", (Object[])new Object[]{this.b.position(), position, length, this.b.limit()});
        ByteBuffer newb = this.b.duplicate();
        newb.position(this.b.position() + position);
        newb.limit(this.b.position() + position + length);
        return new StaticByteBuffer(newb);
    }

    @Override
    public ReadByteBuffer asReadBuffer() {
        return new ReadByteBuffer(this.b);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.b.duplicate();
    }

    @Override
    public <T> T as(StaticBuffer.Factory<T> factory) {
        if (this.b.hasArray()) {
            return factory.get(this.b.array(), this.b.position() + this.b.arrayOffset(), this.b.limit() + this.b.arrayOffset());
        }
        int len = this.length();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getByte(i);
        }
        return factory.get(result, 0, result.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StaticBuffer)) {
            return false;
        }
        return ByteBufferUtil.equals(this, (StaticBuffer)o);
    }

    public int hashCode() {
        return ByteBufferUtil.hashcode(this);
    }

    public String toString() {
        return ByteBufferUtil.toString(this, "-");
    }

    @Override
    public int compareTo(StaticBuffer other) {
        return ByteBufferUtil.compare(this, other);
    }
}

