/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import java.nio.ByteBuffer;

public class WriteByteBuffer
implements WriteBuffer {
    private final ByteBuffer buffer;

    public WriteByteBuffer(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
    }

    @Override
    public WriteBuffer putLong(long val) {
        this.buffer.putLong(val);
        return this;
    }

    @Override
    public WriteBuffer putInt(int val) {
        this.buffer.putInt(val);
        return this;
    }

    @Override
    public WriteBuffer putShort(short val) {
        this.buffer.putShort(val);
        return this;
    }

    @Override
    public WriteBuffer putByte(byte val) {
        this.buffer.put(val);
        return this;
    }

    @Override
    public WriteBuffer putChar(char val) {
        this.buffer.putChar(val);
        return this;
    }

    @Override
    public WriteBuffer putFloat(float val) {
        this.buffer.putFloat(val);
        return this;
    }

    @Override
    public WriteBuffer putDouble(double val) {
        this.buffer.putDouble(val);
        return this;
    }

    @Override
    public int getPosition() {
        return this.buffer.position();
    }

    @Override
    public StaticBuffer getStaticBuffer() {
        return this.getStaticBufferFlipBytes(0, 0);
    }

    @Override
    public StaticBuffer getStaticBufferFlipBytes(int from, int to) {
        ByteBuffer b = this.buffer.duplicate();
        b.flip();
        Preconditions.checkArgument((from >= 0 && from <= to ? 1 : 0) != 0);
        Preconditions.checkArgument((to <= b.limit() ? 1 : 0) != 0);
        for (int i = from; i < to; ++i) {
            b.put(i, ~b.get(i));
        }
        return new StaticByteBuffer(b);
    }
}

