/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TransactionHandle;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ConsistencyLevel;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTxConfig;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticByteBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;

public class KCVSConfiguration {
    private static final List<StaticBuffer> NO_DELETIONS = ImmutableList.of();
    private final KeyColumnValueStoreManager manager;
    private final KeyColumnValueStore store;
    private final String identifier;
    private final StaticBuffer rowKey;
    private long maxOperationWaitTime = 10000L;

    public KCVSConfiguration(KeyColumnValueStoreManager manager, String configurationName, String identifier) throws StorageException {
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)configurationName));
        this.manager = manager;
        this.store = manager.openDatabase(configurationName);
        this.identifier = identifier;
        this.rowKey = this.string2StaticBuffer(this.identifier);
    }

    public void setMaxOperationWaitTime(long waitTimeMS) {
        Preconditions.checkArgument((waitTimeMS > 0L ? 1 : 0) != 0, (String)"Invalid wait time: %s", (Object[])new Object[]{waitTimeMS});
        this.maxOperationWaitTime = waitTimeMS;
    }

    public String getConfigurationProperty(String key) throws StorageException {
        StaticBuffer column = this.string2StaticBuffer(key);
        final KeySliceQuery query = new KeySliceQuery(this.rowKey, column, ByteBufferUtil.nextBiggerBuffer(column), false);
        StaticBuffer result = BackendOperation.execute(new Callable<StaticBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StaticBuffer call() throws Exception {
                TransactionHandle txh = null;
                try {
                    txh = KCVSConfiguration.this.manager.beginTransaction(new StoreTxConfig(ConsistencyLevel.KEY_CONSISTENT));
                    List<Entry> entries = KCVSConfiguration.this.store.getSlice(query, (StoreTransaction)txh);
                    if (entries.isEmpty()) {
                        StaticBuffer staticBuffer = null;
                        return staticBuffer;
                    }
                    StaticBuffer staticBuffer = entries.get(0).getValue();
                    return staticBuffer;
                }
                finally {
                    if (txh != null) {
                        txh.commit();
                    }
                }
            }

            public String toString() {
                return "getConfiguration";
            }
        }, this.maxOperationWaitTime);
        if (result == null) {
            return null;
        }
        return this.staticBuffer2String(result);
    }

    public void setConfigurationProperty(String key, String value) throws StorageException {
        StaticBuffer column = this.string2StaticBuffer(key);
        StaticBuffer val = this.string2StaticBuffer(value);
        final ArrayList<StaticBufferEntry> additions = new ArrayList<StaticBufferEntry>(1);
        additions.add(new StaticBufferEntry(column, val));
        BackendOperation.execute(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                TransactionHandle txh = null;
                try {
                    txh = KCVSConfiguration.this.manager.beginTransaction(new StoreTxConfig(ConsistencyLevel.KEY_CONSISTENT));
                    KCVSConfiguration.this.store.mutate(KCVSConfiguration.this.rowKey, additions, NO_DELETIONS, (StoreTransaction)txh);
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    if (txh != null) {
                        txh.commit();
                    }
                }
            }

            public String toString() {
                return "setConfiguration";
            }
        }, this.maxOperationWaitTime);
    }

    public void close() throws StorageException {
        this.store.close();
    }

    private StaticBuffer string2StaticBuffer(String s) {
        ByteBuffer out = ByteBuffer.wrap(s.getBytes(Charset.forName("UTF-8")));
        return new StaticByteBuffer(out);
    }

    private String staticBuffer2String(StaticBuffer s) {
        return new String(s.as(StaticBuffer.ARRAY_FACTORY), Charset.forName("UTF-8"));
    }
}

