/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;

public class RegisteredAttributeClass<T>
implements Comparable<RegisteredAttributeClass> {
    private final Class<T> type;
    private final AttributeHandler<T> serializer;
    private final int position;

    public RegisteredAttributeClass(Class<T> type, int position) {
        this(type, null, position);
    }

    public RegisteredAttributeClass(Class<T> type, AttributeHandler<T> serializer, int position) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (String)"Invalid position: %s", (Object[])new Object[]{position});
        this.type = type;
        this.serializer = serializer;
        this.position = position;
    }

    private int getPosition() {
        return this.position + 256;
    }

    void registerWith(Serializer s) {
        if (this.serializer == null) {
            s.registerClass(this.type, this.getPosition());
        } else if (this.serializer instanceof AttributeSerializer) {
            s.registerClass(this.type, (AttributeSerializer)this.serializer, this.getPosition());
        } else {
            s.registerClass(this.type, this.serializer);
        }
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        return this.type.equals(((RegisteredAttributeClass)oth).type) || this.position == ((RegisteredAttributeClass)oth).position;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.position;
        if (null != this.type) {
            result = 31 * result + this.type.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.type.toString() + "#" + this.position;
    }

    @Override
    public int compareTo(RegisteredAttributeClass registeredAttributeClass) {
        return this.position - registeredAttributeClass.position;
    }
}

