/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongObjectOpenHashMap;
import com.carrotsearch.hppc.LongOpenHashSet;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.graphdb.database.RelationFactory;
import com.thinkaurelius.titan.graphdb.database.idhandling.IDHandler;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.thinkaurelius.titan.graphdb.relations.CacheProperty;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.Interval;
import com.tinkerpop.blueprints.Direction;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeSerializer {
    private static final Logger logger = LoggerFactory.getLogger(EdgeSerializer.class);
    private static final int DEFAULT_COLUMN_CAPACITY = 60;
    private static final int DEFAULT_VALUE_CAPACITY = 128;
    private final Serializer serializer;

    public EdgeSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public InternalRelation readRelation(InternalVertex vertex, Entry data) {
        StandardTitanTx tx = vertex.tx();
        RelationCache relation = this.readRelation(vertex.getID(), data, true, tx);
        return this.readRelation(vertex, relation, data, tx);
    }

    public InternalRelation readRelation(InternalVertex vertex, RelationCache relation, Entry data, StandardTitanTx tx) {
        TitanType type = tx.getExistingType(relation.typeId);
        if (type.isPropertyKey()) {
            assert (relation.direction == Direction.OUT);
            return new CacheProperty(relation.relationId, (TitanKey)type, vertex, relation.getValue(), data);
        }
        if (type.isEdgeLabel()) {
            InternalVertex otherVertex = tx.getExistingVertex(relation.getOtherVertexId());
            switch (relation.direction) {
                case IN: {
                    return new CacheEdge(relation.relationId, (TitanLabel)type, otherVertex, vertex, 1, data);
                }
                case OUT: {
                    return new CacheEdge(relation.relationId, (TitanLabel)type, vertex, otherVertex, 0, data);
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    public void readRelation(RelationFactory factory, Entry data, StandardTitanTx tx) {
        RelationCache relation = this.readRelation(factory.getVertexID(), data, false, tx);
        assert (relation.hasProperties());
        factory.setDirection(relation.direction);
        TitanType type = tx.getExistingType(relation.typeId);
        factory.setType(type);
        factory.setRelationID(relation.relationId);
        if (type.isPropertyKey()) {
            factory.setValue(relation.getValue());
        } else if (type.isEdgeLabel()) {
            factory.setOtherVertexID(relation.getOtherVertexId());
        } else {
            throw new AssertionError();
        }
        for (LongObjectCursor<Object> entry : relation) {
            TitanType pt = tx.getExistingType(entry.key);
            if (entry.value == null) continue;
            factory.addProperty(pt, entry.value);
        }
    }

    public RelationCache readRelation(InternalVertex vertex, Entry data, StandardTitanTx tx) {
        return this.readRelation(vertex.getID(), data, false, tx);
    }

    public RelationCache readRelation(long vertexid, Entry data, boolean parseHeaderOnly, StandardTitanTx tx) {
        RelationCache map = data.getCache();
        if (map == null || !parseHeaderOnly && !map.hasProperties()) {
            map = this.parseRelation(vertexid, data, parseHeaderOnly, tx);
            data.setCache(map);
        }
        return map;
    }

    public Direction parseDirection(Entry data) {
        RelationCache map = data.getCache();
        if (map != null) {
            return map.direction;
        }
        long[] typeAndDir = IDHandler.readEdgeType(data.getReadColumn());
        switch ((int)typeAndDir[1]) {
            case 0: 
            case 2: {
                return Direction.OUT;
            }
            case 3: {
                return Direction.IN;
            }
        }
        throw new IllegalArgumentException("Invalid dirID read from disk: " + typeAndDir[1]);
    }

    private RelationCache parseRelation(long vertexid, Entry data, boolean parseHeaderOnly, StandardTitanTx tx) {
        Object other;
        long relationIdDiff;
        RelationType rtype;
        Direction dir;
        assert (vertexid > 0L);
        ReadBuffer column = data.getReadColumn();
        ReadBuffer value = data.getReadValue();
        LongObjectOpenHashMap properties = parseHeaderOnly ? null : new LongObjectOpenHashMap(4);
        long[] typeAndDir = IDHandler.readEdgeType(column);
        int dirID = (int)typeAndDir[1];
        long typeId = typeAndDir[0];
        switch (dirID) {
            case 0: {
                dir = Direction.OUT;
                rtype = RelationType.PROPERTY;
                break;
            }
            case 2: {
                dir = Direction.OUT;
                rtype = RelationType.EDGE;
                break;
            }
            case 3: {
                dir = Direction.IN;
                rtype = RelationType.EDGE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid dirID read from disk: " + dirID);
            }
        }
        TitanType titanType = tx.getExistingType(typeId);
        InternalType def = (InternalType)titanType;
        long[] keysig = def.getSortKey();
        if (!parseHeaderOnly && !titanType.isUnique(dir)) {
            ReadBuffer sortKeyReader = def.getSortOrder() == Order.DESC ? column.invert() : column;
            this.readInlineTypes(keysig, properties, sortKeyReader, tx);
        }
        long vertexIdDiff = 0L;
        if (titanType.isUnique(dir)) {
            if (rtype == RelationType.EDGE) {
                vertexIdDiff = VariableLong.read(value);
            }
            relationIdDiff = VariableLong.read(value);
        } else {
            column.movePosition(column.length() - column.getPosition() - 1);
            relationIdDiff = VariableLong.readBackward(column);
            if (rtype == RelationType.EDGE) {
                vertexIdDiff = VariableLong.readBackward(column);
            }
        }
        assert (relationIdDiff + vertexid > 0L);
        long relationId = relationIdDiff + vertexid;
        switch (rtype) {
            case EDGE: {
                Preconditions.checkArgument((boolean)titanType.isEdgeLabel());
                other = vertexid + vertexIdDiff;
                break;
            }
            case PROPERTY: {
                Preconditions.checkArgument((boolean)titanType.isPropertyKey());
                TitanKey key = (TitanKey)titanType;
                other = EdgeSerializer.hasGenericDataType(key) ? this.serializer.readClassAndObject(value) : this.serializer.readObjectNotNull(value, key.getDataType());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        assert (other != null);
        if (!parseHeaderOnly) {
            if (titanType.isUnique(dir)) {
                this.readInlineTypes(keysig, properties, value, tx);
            }
            this.readInlineTypes(def.getSignature(), properties, value, tx);
            while (value.hasRemaining()) {
                TitanType type = tx.getExistingType(IDHandler.readInlineEdgeType(value));
                Object pvalue = this.readInline(value, type);
                assert (pvalue != null);
                properties.put(type.getID(), pvalue);
            }
        }
        return new RelationCache(dir, typeId, relationId, other, (LongObjectOpenHashMap<Object>)properties);
    }

    private void readInlineTypes(long[] typeids, LongObjectOpenHashMap properties, ReadBuffer in, StandardTitanTx tx) {
        for (long typeid : typeids) {
            TitanType keyType = tx.getExistingType(typeid);
            Object value = this.readInline(in, keyType);
            if (value == null) continue;
            properties.put(typeid, value);
        }
    }

    private Object readInline(ReadBuffer read, TitanType type) {
        if (type.isPropertyKey()) {
            TitanKey proptype = (TitanKey)type;
            return EdgeSerializer.hasGenericDataType(proptype) ? this.serializer.readClassAndObject(read) : this.serializer.readObject(read, proptype.getDataType());
        }
        assert (type.isEdgeLabel());
        long id = VariableLong.readPositive(read);
        return id == 0L ? null : Long.valueOf(id);
    }

    private static boolean hasGenericDataType(TitanKey key) {
        return key.getDataType().equals(Object.class);
    }

    private static int getDirID(Direction dir, RelationType rt) {
        switch (rt) {
            case PROPERTY: {
                assert (dir == Direction.OUT);
                return 0;
            }
            case EDGE: {
                switch (dir) {
                    case OUT: {
                        return 2;
                    }
                    case IN: {
                        return 3;
                    }
                }
                throw new IllegalArgumentException("Invalid direction: " + dir);
            }
        }
        throw new IllegalArgumentException("Invalid relation type: " + rt);
    }

    private void writeInlineTypes(long[] typeids, InternalRelation relation, DataOutput out, StandardTitanTx tx) {
        for (long typeid : typeids) {
            TitanType t = tx.getExistingType(typeid);
            this.writeInline(out, t, relation.getProperty(t), false);
        }
    }

    public Entry writeRelation(InternalRelation relation, int position, StandardTitanTx tx) {
        Preconditions.checkArgument((position < relation.getLen() ? 1 : 0) != 0);
        TitanType type = relation.getType();
        long typeid = type.getID();
        Direction dir = EdgeDirection.fromPosition(position);
        int dirID = EdgeSerializer.getDirID(dir, relation.isProperty() ? RelationType.PROPERTY : RelationType.EDGE);
        DataOutput colOut = this.serializer.getDataOutput(60, true);
        IDHandler.writeEdgeType(colOut, typeid, dirID);
        InternalType definition = (InternalType)type;
        long[] sortKey = definition.getSortKey();
        int startPosition = colOut.getPosition();
        if (!type.isUnique(dir)) {
            this.writeInlineTypes(sortKey, relation, colOut, tx);
        }
        int endPosition = colOut.getPosition();
        DataOutput writer = colOut;
        long vertexIdDiff = 0L;
        long relationIdDiff = relation.getID() - relation.getVertex(position).getID();
        if (relation.isEdge()) {
            vertexIdDiff = relation.getVertex((position + 1) % 2).getID() - relation.getVertex(position).getID();
        }
        if (type.isUnique(dir)) {
            writer = this.serializer.getDataOutput(128, true);
            if (relation.isEdge()) {
                VariableLong.write(writer, vertexIdDiff);
            }
            VariableLong.write(writer, relationIdDiff);
        } else {
            if (relation.isEdge()) {
                VariableLong.writeBackward(writer, vertexIdDiff);
            }
            VariableLong.writeBackward(writer, relationIdDiff);
        }
        if (!type.isUnique(dir)) {
            writer = this.serializer.getDataOutput(128, true);
        }
        if (relation.isProperty()) {
            Preconditions.checkArgument((boolean)relation.isProperty());
            Object value = ((TitanProperty)((Object)relation)).getValue();
            Preconditions.checkNotNull((Object)value);
            TitanKey key = (TitanKey)type;
            assert (key.getDataType().isInstance(value));
            if (EdgeSerializer.hasGenericDataType(key)) {
                writer.writeClassAndObject(value);
            } else {
                writer.writeObjectNotNull(value);
            }
        }
        if (type.isUnique(dir)) {
            this.writeInlineTypes(sortKey, relation, writer, tx);
        }
        long[] signature = definition.getSignature();
        this.writeInlineTypes(signature, relation, writer, tx);
        LongOpenHashSet writtenTypes = new LongOpenHashSet(sortKey.length + signature.length);
        if (sortKey.length > 0 || signature.length > 0) {
            for (long id : sortKey) {
                writtenTypes.add(id);
            }
            for (long id : signature) {
                writtenTypes.add(id);
            }
        }
        LongArrayList remainingTypes = new LongArrayList(8);
        for (TitanType t : relation.getPropertyKeysDirect()) {
            if (writtenTypes.contains(t.getID())) continue;
            remainingTypes.add(t.getID());
        }
        long[] remaining = remainingTypes.toArray();
        Arrays.sort(remaining);
        for (long tid : remaining) {
            TitanType t = tx.getExistingType(tid);
            this.writeInline(writer, t, relation.getProperty(t), true);
        }
        StaticBuffer column = ((InternalType)type).getSortOrder() == Order.DESC ? colOut.getStaticBufferFlipBytes(startPosition, endPosition) : colOut.getStaticBuffer();
        return new StaticBufferEntry(column, writer.getStaticBuffer());
    }

    private void writeInline(DataOutput out, TitanType type, Object value, boolean writeEdgeType) {
        Preconditions.checkArgument((!type.isPropertyKey() || writeEdgeType || !EdgeSerializer.hasGenericDataType((TitanKey)type) ? 1 : 0) != 0);
        if (writeEdgeType) {
            IDHandler.writeInlineEdgeType(out, type.getID());
        }
        if (type.isPropertyKey()) {
            if (EdgeSerializer.hasGenericDataType((TitanKey)type)) {
                out.writeClassAndObject(value);
            } else {
                out.writeObject(value, ((TitanKey)type).getDataType());
            }
        } else {
            assert (type.isEdgeLabel());
            Preconditions.checkArgument((boolean)((TitanLabel)type).isUnidirected());
            if (value == null) {
                VariableLong.writePositive(out, 0L);
            } else {
                VariableLong.writePositive(out, ((InternalVertex)value).getID());
            }
        }
    }

    public SliceQuery getQuery(RelationType resultType) {
        Preconditions.checkNotNull((Object)resultType);
        StaticBuffer[] bound = IDHandler.getBounds(resultType);
        return new SliceQuery(bound[0], bound[1]);
    }

    public SliceQuery getQuery(InternalType type, Direction dir, TypedInterval[] sortKey, VertexConstraint vertexCon) {
        boolean isStatic;
        RelationType rt;
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)dir);
        StaticBuffer sliceStart = null;
        StaticBuffer sliceEnd = null;
        RelationType relationType = rt = type.isPropertyKey() ? RelationType.PROPERTY : RelationType.EDGE;
        if (dir == Direction.BOTH) {
            isStatic = type.isStatic(Direction.OUT) && type.isStatic(Direction.IN);
            sliceStart = IDHandler.getEdgeType(type.getID(), EdgeSerializer.getDirID(Direction.OUT, rt));
            sliceEnd = IDHandler.getEdgeType(type.getID(), EdgeSerializer.getDirID(Direction.IN, rt));
            assert (ByteBufferUtil.isSmallerThan(sliceStart, sliceEnd));
            sliceEnd = ByteBufferUtil.nextBiggerBuffer(sliceEnd);
        } else {
            boolean wroteEntireSortKey;
            int i;
            isStatic = type.isStatic(dir);
            int dirID = EdgeSerializer.getDirID(dir, rt);
            DataOutput colStart = this.serializer.getDataOutput(60, true);
            DataOutput colEnd = this.serializer.getDataOutput(60, true);
            IDHandler.writeEdgeType(colStart, type.getID(), dirID);
            IDHandler.writeEdgeType(colEnd, type.getID(), dirID);
            long[] sortKeyIDs = type.getSortKey();
            Preconditions.checkArgument((sortKey.length == sortKeyIDs.length ? 1 : 0) != 0);
            assert (colStart.getPosition() == colEnd.getPosition());
            int startPosition = colStart.getPosition();
            boolean wroteInterval = false;
            for (i = 0; i < sortKeyIDs.length && sortKey[i] != null; ++i) {
                InternalType t = sortKey[i].type;
                Interval interval = sortKey[i].interval;
                if (interval == null || interval.isEmpty()) break;
                Preconditions.checkArgument((t.getID() == sortKeyIDs[i] ? 1 : 0) != 0);
                Preconditions.checkArgument((!type.isUnique(dir) ? 1 : 0) != 0, (Object)"Cannot apply sort key to the unique direction");
                if (!interval.isPoint()) {
                    if (interval.getStart() != null) {
                        this.writeInline(colStart, t, interval.getStart(), false);
                    }
                    if (interval.getEnd() != null) {
                        this.writeInline(colEnd, t, interval.getEnd(), false);
                    }
                    switch (type.getSortOrder()) {
                        case ASC: {
                            sliceStart = colStart.getStaticBuffer();
                            sliceEnd = colEnd.getStaticBuffer();
                            if (!interval.startInclusive()) {
                                sliceStart = ByteBufferUtil.nextBiggerBuffer(sliceStart);
                            }
                            if (!interval.endInclusive()) break;
                            sliceEnd = ByteBufferUtil.nextBiggerBuffer(sliceEnd);
                            break;
                        }
                        case DESC: {
                            sliceEnd = colStart.getStaticBufferFlipBytes(startPosition, colStart.getPosition());
                            sliceStart = colEnd.getStaticBufferFlipBytes(startPosition, colEnd.getPosition());
                            if (interval.startInclusive()) {
                                sliceEnd = ByteBufferUtil.nextBiggerBuffer(sliceEnd);
                            }
                            if (interval.endInclusive()) break;
                            sliceStart = ByteBufferUtil.nextBiggerBuffer(sliceStart);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)type.getSortOrder().toString());
                        }
                    }
                    assert (sliceStart.compareTo(sliceEnd) <= 0);
                    wroteInterval = true;
                    break;
                }
                this.writeInline(colStart, t, interval.getStart(), false);
                this.writeInline(colEnd, t, interval.getEnd(), false);
            }
            boolean bl = wroteEntireSortKey = i >= sortKeyIDs.length;
            assert (!wroteEntireSortKey || !wroteInterval);
            assert (!wroteInterval || vertexCon == null);
            if (!wroteInterval) {
                assert (colStart.getPosition() == colEnd.getPosition());
                int endPosition = colStart.getPosition();
                if (vertexCon != null) {
                    assert (!wroteInterval);
                    Preconditions.checkArgument((wroteEntireSortKey && !type.isUnique(dir) ? 1 : 0) != 0);
                    Preconditions.checkArgument((boolean)type.isEdgeLabel());
                    long vertexIdDiff = vertexCon.getVertexIdDiff();
                    VariableLong.writeBackward(colStart, vertexIdDiff);
                }
                switch (type.getSortOrder()) {
                    case ASC: {
                        sliceStart = colStart.getStaticBuffer();
                        break;
                    }
                    case DESC: {
                        sliceStart = colStart.getStaticBufferFlipBytes(startPosition, endPosition);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)type.getSortOrder().toString());
                    }
                }
                sliceEnd = ByteBufferUtil.nextBiggerBuffer(sliceStart);
            }
        }
        return new SliceQuery(sliceStart, sliceEnd, isStatic);
    }

    public static class TypedInterval {
        public final InternalType type;
        public final Interval interval;

        public TypedInterval(InternalType type, Interval interval) {
            this.type = type;
            this.interval = interval;
        }
    }

    public static class VertexConstraint {
        public final long vertexID;
        public final long otherVertexID;

        public VertexConstraint(long vertexID, long otherVertexID) {
            this.vertexID = vertexID;
            this.otherVertexID = otherVertexID;
        }

        private long getVertexIdDiff() {
            return this.otherVertexID - this.vertexID;
        }
    }
}

