/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.indexing.IndexInformation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.indexing.StandardKeyInformation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StaticBufferEntry;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.ElementType;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.IndexQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanKeyVertex;
import com.thinkaurelius.titan.util.encoding.LongEncoding;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSerializer {
    private static final Logger log = LoggerFactory.getLogger(IndexSerializer.class);
    private static final int DEFAULT_VALUE_CAPACITY = 40;
    private final Serializer serializer;
    private final Map<String, ? extends IndexInformation> indexes;

    public IndexSerializer(Serializer serializer, Map<String, ? extends IndexInformation> indexes) {
        this.serializer = serializer;
        this.indexes = indexes;
    }

    public boolean supports(String indexName, Class<?> dataType, Parameter[] parameters) {
        IndexInformation indexinfo = this.indexes.get(indexName);
        Preconditions.checkArgument((indexinfo != null ? 1 : 0) != 0, (String)"Index is unknown or not configured: %s", (Object[])new Object[]{indexName});
        return indexinfo.supports(new StandardKeyInformation(dataType, parameters));
    }

    public boolean supports(String indexName, ElementType result, TitanKey key, TitanPredicate predicate) {
        IndexInformation indexinfo = this.indexes.get(indexName);
        Preconditions.checkArgument((indexinfo != null ? 1 : 0) != 0, (String)"Index is unknown or not configured: %s", (Object[])new Object[]{indexName});
        return indexinfo.supports(IndexSerializer.getKeyInformation(key, result.getElementType(), indexName), predicate);
    }

    private static StandardKeyInformation getKeyInformation(TitanKey key, Class<? extends Element> type, String index) {
        return new StandardKeyInformation(key.getDataType(), key instanceof TitanKeyVertex ? ((TitanKeyVertex)key).getIndex(index, type).getParameters() : new Parameter[]{});
    }

    public IndexInfoRetriever getIndexInforRetriever() {
        return new IndexInfoRetriever();
    }

    public void newPropertyKey(TitanKey key, BackendTransaction tx) throws StorageException {
        for (String index : key.getIndexes(Vertex.class)) {
            if (index.equals("standard")) continue;
            tx.getIndexTransactionHandle(index).register(ElementType.VERTEX.getName(), IndexSerializer.key2String(key), IndexSerializer.getKeyInformation(key, Vertex.class, index));
        }
        for (String index : key.getIndexes(Edge.class)) {
            if (index.equals("standard")) continue;
            tx.getIndexTransactionHandle(index).register(ElementType.EDGE.getName(), IndexSerializer.key2String(key), IndexSerializer.getKeyInformation(key, Edge.class, index));
        }
    }

    public void addProperty(TitanProperty prop, BackendTransaction tx) throws StorageException {
        TitanKey key = prop.getPropertyKey();
        for (String index : key.getIndexes(Vertex.class)) {
            if (index.equals("standard")) {
                tx.mutateVertexIndex(this.getIndexKey(prop.getValue()), Lists.newArrayList((Object[])new Entry[]{StaticBufferEntry.of(IndexSerializer.getIndexColumn(key, prop), IndexSerializer.getIndexValue(prop))}), KeyColumnValueStore.NO_DELETIONS);
                continue;
            }
            this.addKeyValue(prop.getVertex(), key, prop.getValue(), index, tx);
        }
    }

    public void removeProperty(TitanProperty prop, BackendTransaction tx) throws StorageException {
        TitanKey key = prop.getPropertyKey();
        for (String index : key.getIndexes(Vertex.class)) {
            if (index.equals("standard")) {
                tx.mutateVertexIndex(this.getIndexKey(prop.getValue()), KeyColumnValueStore.NO_ADDITIONS, Lists.newArrayList((Object[])new StaticBuffer[]{IndexSerializer.getIndexColumn(key, prop)}));
                continue;
            }
            this.removeKeyValue(prop.getVertex(), key, index, tx);
        }
    }

    public void lockKeyedProperty(TitanProperty prop, BackendTransaction tx) throws StorageException {
        TitanKey key = prop.getPropertyKey();
        if (key.isUnique(Direction.IN) && ((InternalType)((Object)key)).uniqueLock(Direction.IN)) {
            Preconditions.checkArgument((boolean)key.hasIndex("standard", Vertex.class), (String)"Standard Index needs to be created for property to be declared unique [%s]", (Object[])new Object[]{key.getName()});
            Preconditions.checkArgument((prop.isNew() || prop.isRemoved() ? 1 : 0) != 0);
            tx.acquireVertexIndexLock(this.getIndexKey(prop.getValue()), IndexSerializer.getIndexColumn(key, prop), prop.isNew() ? null : IndexSerializer.getIndexValue(prop));
        }
    }

    public void addEdge(InternalRelation relation, BackendTransaction tx) throws StorageException {
        Preconditions.checkArgument((boolean)(relation instanceof TitanEdge), (Object)"Only edges can be indexed for now");
        for (TitanType type : relation.getPropertyKeysDirect()) {
            if (!(type instanceof TitanKey)) continue;
            TitanKey key = (TitanKey)type;
            for (String index : key.getIndexes(Edge.class)) {
                Object value = relation.getPropertyDirect(key);
                if (index.equals("standard")) {
                    tx.mutateEdgeIndex(this.getIndexKey(value), Lists.newArrayList((Object[])new Entry[]{StaticBufferEntry.of(IndexSerializer.getIDIndexColumn(key, relation.getID()), IndexSerializer.relationID2ByteBuffer((RelationIdentifier)relation.getId()))}), KeyColumnValueStore.NO_DELETIONS);
                    continue;
                }
                this.addKeyValue(relation, key, value, index, tx);
            }
        }
    }

    public void removeEdge(InternalRelation relation, BackendTransaction tx) throws StorageException {
        Preconditions.checkArgument((boolean)(relation instanceof TitanEdge), (Object)"Only edges can be indexed for now");
        for (TitanType type : relation.getPropertyKeysDirect()) {
            if (!(type instanceof TitanKey)) continue;
            TitanKey key = (TitanKey)type;
            for (String index : key.getIndexes(Edge.class)) {
                Object value = relation.getPropertyDirect(key);
                if (index.equals("standard")) {
                    tx.mutateEdgeIndex(this.getIndexKey(value), KeyColumnValueStore.NO_ADDITIONS, Lists.newArrayList((Object[])new StaticBuffer[]{IndexSerializer.getIDIndexColumn(key, relation.getID())}));
                    continue;
                }
                this.removeKeyValue(relation, key, index, tx);
            }
        }
    }

    private void addKeyValue(TitanElement element, TitanKey key, Object value, String index, BackendTransaction tx) throws StorageException {
        Preconditions.checkArgument((boolean)key.isUnique(Direction.OUT), (String)"Only out-unique properties are supported by index [%s]", (Object[])new Object[]{index});
        tx.getIndexTransactionHandle(index).add(IndexSerializer.getStoreName(element), IndexSerializer.element2String(element), IndexSerializer.key2String(key), value, element.isNew());
    }

    private void removeKeyValue(TitanElement element, TitanKey key, String index, BackendTransaction tx) {
        Preconditions.checkArgument((boolean)key.isUnique(Direction.OUT), (String)"Only out-unique properties are supported by index [%s]", (Object[])new Object[]{index});
        tx.getIndexTransactionHandle(index).delete(IndexSerializer.getStoreName(element), IndexSerializer.element2String(element), IndexSerializer.key2String(key), element.isRemoved());
    }

    public List<Object> query(String indexName, IndexQuery query, final BackendTransaction tx) {
        Preconditions.checkArgument((boolean)this.indexes.containsKey(indexName), (String)"Index unknown or unconfigured: %s", (Object[])new Object[]{indexName});
        if (IndexSerializer.isStandardIndex(indexName)) {
            Preconditions.checkArgument((boolean)query.getOrder().isEmpty(), (Object)"Standard index does not support ordering");
            List results = null;
            final ElementType resultType = IndexSerializer.getElementType(query.getStore());
            final Condition<TitanElement> condition = query.getCondition();
            if (condition instanceof And) {
                ArrayList retrievals = new ArrayList(condition.numChildren());
                for (final Condition subcond : ((And)condition).getChildren()) {
                    retrievals.add(new QueryUtil.IndexCall<Object>(){

                        @Override
                        public Collection<Object> call(int limit) {
                            Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
                            List<Object> r = null;
                            if (subcond instanceof Or) {
                                r = new ArrayList<Object>(limit);
                                for (Condition nested : subcond.getChildren()) {
                                    Preconditions.checkArgument((boolean)(nested instanceof PredicateCondition), (String)"Invalid query (not in QNF): %s", (Object[])new Object[]{condition});
                                    r.addAll(IndexSerializer.this.processSingleCondition(resultType, (PredicateCondition)nested, limit, tx));
                                    if (r.size() < limit) continue;
                                    break;
                                }
                            } else if (subcond instanceof PredicateCondition) {
                                r = IndexSerializer.this.processSingleCondition(resultType, (PredicateCondition)subcond, limit, tx);
                            } else {
                                throw new IllegalArgumentException("Invalid query provided (original not in QNF):" + subcond);
                            }
                            return r;
                        }
                    });
                }
                results = QueryUtil.processIntersectingRetrievals(retrievals, query.getLimit());
            } else {
                Preconditions.checkArgument((boolean)false, (String)"Invalid query (not in QNF): %s", (Object[])new Object[]{condition});
            }
            return results;
        }
        List<String> r = tx.indexQuery(indexName, query);
        ArrayList<Object> result = new ArrayList<Object>(r.size());
        for (String id : r) {
            result.add(IndexSerializer.string2ElementId(id));
        }
        return result;
    }

    private List<Object> processSingleCondition(ElementType resultType, PredicateCondition pc, int limit, BackendTransaction tx) {
        Preconditions.checkArgument((resultType == ElementType.EDGE || resultType == ElementType.VERTEX ? 1 : 0) != 0);
        Preconditions.checkArgument((pc.getPredicate() == Cmp.EQUAL ? 1 : 0) != 0, (Object)"Only equality index retrievals are supported on standard index");
        Preconditions.checkNotNull((Object)pc.getValue());
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        TitanKey key = (TitanKey)pc.getKey();
        Preconditions.checkArgument((boolean)key.hasIndex("standard", resultType.getElementType()), (String)"Cannot retrieve for given property key - it does not have an index [%s]", (Object[])new Object[]{key.getName()});
        Object value = pc.getValue();
        StaticBuffer column = IndexSerializer.getUniqueIndexColumn(key);
        KeySliceQuery sq = new KeySliceQuery(this.getIndexKey(value), column, SliceQuery.pointRange(column), ((InternalType)((Object)key)).isStatic(Direction.IN)).setLimit(limit);
        List<Entry> r = resultType == ElementType.VERTEX ? tx.vertexIndexQuery(sq) : tx.edgeIndexQuery(sq);
        ArrayList<Object> results = new ArrayList<Object>(r.size());
        for (Entry entry : r) {
            ReadBuffer entryValue = entry.getReadValue();
            if (resultType == ElementType.VERTEX) {
                results.add(VariableLong.readPositive(entryValue));
                continue;
            }
            results.add(IndexSerializer.bytebuffer2RelationId(entryValue));
        }
        Preconditions.checkArgument((resultType != ElementType.VERTEX || !key.isUnique(Direction.IN) || results.size() <= 1 ? 1 : 0) != 0);
        return results;
    }

    public IndexQuery getQuery(String index, ElementType resultType, Condition condition, OrderList orders) {
        if (IndexSerializer.isStandardIndex(index)) {
            Preconditions.checkArgument((boolean)orders.isEmpty());
            return new IndexQuery(IndexSerializer.getStoreName(resultType), condition, IndexQuery.NO_ORDER);
        }
        Condition<TitanElement> newCondition = ConditionUtil.literalTransformation(condition, new Function<Condition<TitanElement>, Condition<TitanElement>>(){

            @Nullable
            public Condition<TitanElement> apply(@Nullable Condition<TitanElement> condition) {
                Preconditions.checkArgument((boolean)(condition instanceof PredicateCondition));
                PredicateCondition pc = (PredicateCondition)condition;
                TitanKey key = (TitanKey)pc.getKey();
                return new PredicateCondition(IndexSerializer.key2String(key), pc.getPredicate(), pc.getValue());
            }
        });
        ImmutableList newOrders = IndexQuery.NO_ORDER;
        if (!orders.isEmpty()) {
            ImmutableList.Builder lb = ImmutableList.builder();
            for (int i = 0; i < orders.size(); ++i) {
                lb.add((Object)new IndexQuery.OrderEntry(IndexSerializer.key2String(orders.getKey(i)), orders.getOrder(i), orders.getKey(i).getDataType()));
            }
            newOrders = lb.build();
        }
        return new IndexQuery(IndexSerializer.getStoreName(resultType), newCondition, newOrders);
    }

    public Iterable<RawQuery.Result> executeQuery(IndexQueryBuilder query, ElementType resultType, BackendTransaction backendTx, StandardTitanTx transaction) {
        StringBuffer qB = new StringBuffer(query.getQuery());
        String prefix = query.getPrefix();
        Preconditions.checkNotNull((Object)prefix);
        int replacements = 0;
        int pos = 0;
        while (pos < qB.length() && (pos = qB.indexOf(prefix, pos)) >= 0) {
            String replacement;
            boolean quoteTerminated;
            int startPos = pos;
            StringBuilder keyBuilder = new StringBuilder();
            boolean bl = quoteTerminated = qB.charAt(pos += prefix.length()) == '\"';
            if (quoteTerminated) {
                ++pos;
            }
            while (pos < qB.length() && (Character.isLetterOrDigit(qB.charAt(pos)) || quoteTerminated && qB.charAt(pos) != '\"')) {
                keyBuilder.append(qB.charAt(pos));
                ++pos;
            }
            if (quoteTerminated) {
                // empty if block
            }
            int endPos = ++pos;
            String keyname = keyBuilder.toString();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)keyname), (String)"Found reference to empty key at position [%s]", (Object[])new Object[]{startPos});
            if (transaction.containsType(keyname)) {
                TitanKey key = transaction.getPropertyKey(keyname);
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)key.hasIndex(query.getIndex(), resultType.getElementType()), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object[])new Object[]{key.getName(), query.getIndex()});
                replacement = IndexSerializer.key2String(key);
            } else {
                Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to non-existant property key in query at position [%s]: %s", (Object[])new Object[]{startPos, keyname});
                replacement = query.getUnknownKeyName();
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)replacement));
            qB.replace(startPos, endPos, replacement);
            pos = startPos + replacement.length();
            ++replacements;
        }
        String queryStr = qB.toString();
        Preconditions.checkArgument((replacements > 0 ? 1 : 0) != 0, (String)"Could not convert given %s index query: %s", (Object[])new Object[]{resultType, query.getQuery()});
        log.info("Converted query string with {} replacements: [{}] => [{}]", new Object[]{replacements, query.getQuery(), queryStr});
        RawQuery rawQuery = new RawQuery(IndexSerializer.getStoreName(resultType), queryStr, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        return Iterables.transform(backendTx.rawQuery(query.getIndex(), rawQuery), (Function)new Function<RawQuery.Result<String>, RawQuery.Result>(){

            @Nullable
            public RawQuery.Result apply(@Nullable RawQuery.Result<String> result) {
                return new RawQuery.Result<Object>(IndexSerializer.string2ElementId(result.getResult()), result.getScore());
            }
        });
    }

    private static final boolean isStandardIndex(String index) {
        return index.equals("standard");
    }

    private static final StaticBuffer relationID2ByteBuffer(RelationIdentifier rid) {
        long[] longs = rid.getLongRepresentation();
        Preconditions.checkArgument((longs.length == 3 ? 1 : 0) != 0);
        WriteByteBuffer buffer = new WriteByteBuffer(24);
        for (int i = 0; i < 3; ++i) {
            VariableLong.writePositive(buffer, longs[i]);
        }
        return buffer.getStaticBuffer();
    }

    private static final RelationIdentifier bytebuffer2RelationId(ReadBuffer b) {
        long[] relationId = new long[3];
        for (int i = 0; i < 3; ++i) {
            relationId[i] = VariableLong.readPositive(b);
        }
        return RelationIdentifier.get(relationId);
    }

    private static final String element2String(TitanElement element) {
        if (element instanceof TitanVertex) {
            return IndexSerializer.longID2Name(element.getID());
        }
        RelationIdentifier rid = (RelationIdentifier)element.getId();
        return rid.toString();
    }

    private static final Object string2ElementId(String str) {
        if (str.contains("-")) {
            return RelationIdentifier.parse(str);
        }
        return IndexSerializer.name2LongID(str);
    }

    private static final String key2String(TitanKey key) {
        return IndexSerializer.longID2Name(key.getID());
    }

    private static final long string2KeyId(String key) {
        return IndexSerializer.name2LongID(key);
    }

    private static final String longID2Name(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        return LongEncoding.encode(id);
    }

    private static final long name2LongID(String name) {
        return LongEncoding.decode(name);
    }

    private static final String getStoreName(Element element) {
        if (element instanceof TitanVertex) {
            return IndexSerializer.getStoreName(ElementType.VERTEX);
        }
        if (element instanceof TitanEdge) {
            return IndexSerializer.getStoreName(ElementType.EDGE);
        }
        throw new IllegalArgumentException("Invalid class: " + element.getClass());
    }

    private static final String getStoreName(ElementType type) {
        return type.getName();
    }

    private static final ElementType getElementType(String store) {
        return ElementType.getByName(store);
    }

    private final StaticBuffer getIndexKey(Object att) {
        DataOutput out = this.serializer.getDataOutput(40, true);
        out.writeObjectNotNull(att);
        return out.getStaticBuffer();
    }

    private static final StaticBuffer getIndexValue(TitanProperty prop) {
        return VariableLong.positiveByteBuffer(new long[]{prop.getVertex().getID(), prop.getID()});
    }

    private static final StaticBuffer getIndexColumn(TitanKey key, TitanProperty prop) {
        if (key.isUnique(Direction.IN)) {
            return IndexSerializer.getUniqueIndexColumn(key);
        }
        if (key.isUnique(Direction.OUT)) {
            return IndexSerializer.getIDIndexColumn(key, prop.getVertex().getID());
        }
        return IndexSerializer.getIDIndexColumn(key, prop.getID());
    }

    private static final StaticBuffer getUniqueIndexColumn(TitanKey type) {
        return VariableLong.positiveByteBuffer(type.getID());
    }

    private static final StaticBuffer getIDIndexColumn(TitanKey type, long propertyID) {
        return VariableLong.positiveByteBuffer(new long[]{type.getID(), propertyID});
    }

    public static class IndexInfoRetriever
    implements KeyInformation.Retriever {
        private StandardTitanTx transaction;

        private IndexInfoRetriever() {
        }

        public void setTransaction(StandardTitanTx tx) {
            Preconditions.checkNotNull((Object)tx);
            Preconditions.checkArgument((this.transaction == null ? 1 : 0) != 0);
            this.transaction = tx;
        }

        @Override
        public KeyInformation.IndexRetriever get(final String index) {
            return new KeyInformation.IndexRetriever(){

                @Override
                public KeyInformation get(String store, String key) {
                    Preconditions.checkState((IndexInfoRetriever.this.transaction != null ? 1 : 0) != 0, (Object)"Retriever has not been initialized");
                    long keyid = IndexSerializer.string2KeyId(key);
                    TitanKey titanKey = (TitanKey)IndexInfoRetriever.this.transaction.getExistingType(keyid);
                    ElementType elementType = IndexSerializer.getElementType(store);
                    return IndexSerializer.getKeyInformation(titanKey, elementType.getElementType(), index);
                }

                @Override
                public KeyInformation.StoreRetriever get(final String store) {
                    final 1 retriever = this;
                    return new KeyInformation.StoreRetriever(){

                        @Override
                        public KeyInformation get(String key) {
                            return retriever.get(store, key);
                        }
                    };
                }
            };
        }
    }
}

