/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.tinkerpop.blueprints.Direction;
import java.util.EnumMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class RelationQueryCache {
    private final Cache<Long, CacheEntry> cache;
    private final EdgeSerializer edgeSerializer;
    private final EnumMap<RelationType, SliceQuery> relationTypes;

    public RelationQueryCache(EdgeSerializer edgeSerializer) {
        this(edgeSerializer, 256);
    }

    public RelationQueryCache(EdgeSerializer edgeSerializer, int capacity) {
        this.edgeSerializer = edgeSerializer;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)(capacity * 3 / 2)).initialCapacity(capacity).concurrencyLevel(2).build();
        this.relationTypes = new EnumMap(RelationType.class);
        for (RelationType rt : RelationType.values()) {
            this.relationTypes.put(rt, edgeSerializer.getQuery(rt));
        }
    }

    public SliceQuery getQuery(RelationType type) {
        return this.relationTypes.get(type);
    }

    public SliceQuery getQuery(final InternalType type, Direction dir) {
        CacheEntry ce;
        try {
            ce = (CacheEntry)this.cache.get((Object)type.getID(), (Callable)new Callable<CacheEntry>(){

                @Override
                public CacheEntry call() throws Exception {
                    return new CacheEntry(RelationQueryCache.this.edgeSerializer, type);
                }
            });
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)("Should not happen: " + e.getMessage()));
        }
        assert (ce != null);
        return ce.get(dir);
    }

    public void close() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static final class CacheEntry {
        private final SliceQuery in;
        private final SliceQuery out;
        private final SliceQuery both;

        public CacheEntry(EdgeSerializer edgeSerializer, InternalType t) {
            if (t.isPropertyKey()) {
                this.in = this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[0], null);
                this.both = this.out;
            } else {
                this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[t.getSortKey().length], null);
                this.in = edgeSerializer.getQuery(t, Direction.IN, new EdgeSerializer.TypedInterval[t.getSortKey().length], null);
                this.both = edgeSerializer.getQuery(t, Direction.BOTH, new EdgeSerializer.TypedInterval[t.getSortKey().length], null);
            }
        }

        public SliceQuery get(Direction dir) {
            switch (dir) {
                case IN: {
                    return this.in;
                }
                case OUT: {
                    return this.out;
                }
                case BOTH: {
                    return this.both;
                }
            }
            throw new AssertionError((Object)("Unknown direction: " + dir));
        }
    }
}

