/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsGraph;
import com.thinkaurelius.titan.graphdb.blueprints.TitanFeatures;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.RelationQueryCache;
import com.thinkaurelius.titan.graphdb.database.cache.StoreCache;
import com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner;
import com.thinkaurelius.titan.graphdb.database.idhandling.IDHandler;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.StandardTransactionBuilder;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import com.thinkaurelius.titan.graphdb.types.system.SystemKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemTypeManager;
import com.thinkaurelius.titan.graphdb.util.ExceptionFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Features;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTitanGraph
extends TitanBlueprintsGraph {
    private static final Logger log = LoggerFactory.getLogger(StandardTitanGraph.class);
    private final GraphDatabaseConfiguration config;
    private final IDManager idManager;
    private final VertexIDAssigner idAssigner;
    private boolean isOpen;
    private final Backend backend;
    private final int maxWriteRetryAttempts;
    private final int retryStorageWaitTime;
    protected final IndexSerializer indexSerializer;
    protected final EdgeSerializer edgeSerializer;
    protected final Serializer serializer;
    public final SliceQuery vertexExistenceQuery;
    private final RelationQueryCache relationCache;
    private final StoreCache edgeStoreCache;

    public StandardTitanGraph(GraphDatabaseConfiguration configuration) {
        this.config = configuration;
        this.backend = configuration.getBackend();
        this.maxWriteRetryAttempts = this.config.getWriteAttempts();
        this.retryStorageWaitTime = this.config.getStorageWaittime();
        this.idAssigner = this.config.getIDAssigner(this.backend);
        this.idManager = this.idAssigner.getIDManager();
        this.serializer = this.config.getSerializer();
        this.indexSerializer = new IndexSerializer(this.serializer, this.backend.getIndexInformation());
        this.edgeSerializer = new EdgeSerializer(this.serializer);
        this.vertexExistenceQuery = this.edgeSerializer.getQuery(SystemKey.VertexState, Direction.OUT, new EdgeSerializer.TypedInterval[0], null).setLimit(1);
        this.relationCache = new RelationQueryCache(this.edgeSerializer);
        this.edgeStoreCache = this.config.getEdgeStoreCache();
        this.isOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized void shutdown() throws TitanException {
        if (!this.isOpen) {
            return;
        }
        try {
            super.shutdown();
            this.idAssigner.close();
            this.backend.close();
            this.edgeStoreCache.close();
            this.relationCache.close();
        }
        catch (StorageException e) {
            throw new TitanException("Could not close storage backend", e);
        }
        finally {
            this.isOpen = false;
        }
    }

    public Features getFeatures() {
        return TitanFeatures.getFeatures(this.getConfiguration(), this.backend.getStoreFeatures());
    }

    @Override
    public TitanTransaction newTransaction() {
        return this.buildTransaction().start();
    }

    @Override
    public StandardTransactionBuilder buildTransaction() {
        return new StandardTransactionBuilder(this.getConfiguration(), this);
    }

    @Override
    public TitanTransaction newThreadBoundTransaction() {
        return this.buildTransaction().threadBound().start();
    }

    public StandardTitanTx newTransaction(TransactionConfiguration configuration) {
        if (!this.isOpen) {
            ExceptionFactory.graphShutdown();
        }
        try {
            IndexSerializer.IndexInfoRetriever retriever = this.indexSerializer.getIndexInforRetriever();
            StandardTitanTx tx = new StandardTitanTx(this, configuration, this.backend.beginTransaction(configuration, retriever));
            retriever.setTransaction(tx);
            return tx;
        }
        catch (StorageException e) {
            throw new TitanException("Could not start new transaction", e);
        }
    }

    public IndexSerializer getIndexSerializer() {
        return this.indexSerializer;
    }

    public IDInspector getIDInspector() {
        return this.idManager.getIDInspector();
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public AttributeHandling getAttributeHandling() {
        return this.serializer;
    }

    public RelationQueryCache getRelationCache() {
        return this.relationCache;
    }

    public GraphDatabaseConfiguration getConfiguration() {
        return this.config;
    }

    public RecordIterator<Long> getVertexIDs(BackendTransaction tx) {
        Preconditions.checkArgument((this.backend.getStoreFeatures().supportsOrderedScan() || this.backend.getStoreFeatures().supportsUnorderedScan() ? 1 : 0) != 0, (Object)"The configured storage backend does not support global graph operations - use Faunus instead");
        final KeyIterator keyiter = this.backend.getStoreFeatures().supportsUnorderedScan() ? tx.edgeStoreKeys(this.vertexExistenceQuery) : tx.edgeStoreKeys(new KeyRangeQuery(IDHandler.MIN_KEY, IDHandler.MAX_KEY, this.vertexExistenceQuery));
        return new RecordIterator<Long>(){

            @Override
            public boolean hasNext() {
                return keyiter.hasNext();
            }

            @Override
            public Long next() {
                return IDHandler.getKeyID((StaticBuffer)keyiter.next());
            }

            @Override
            public void close() throws IOException {
                keyiter.close();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported");
            }
        };
    }

    public List<Entry> edgeQuery(long vid, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vid > 0L ? 1 : 0) != 0);
        return this.edgeStoreCache.query(new KeySliceQuery(IDHandler.getKey(vid), query), tx);
    }

    public List<List<Entry>> edgeMultiQuery(LongArrayList vids, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vids != null && !vids.isEmpty() ? 1 : 0) != 0);
        ArrayList<StaticBuffer> vertexIds = new ArrayList<StaticBuffer>(vids.size());
        for (int i = 0; i < vids.size(); ++i) {
            Preconditions.checkArgument((vids.get(i) > 0L ? 1 : 0) != 0);
            vertexIds.add(IDHandler.getKey(vids.get(i)));
        }
        return this.edgeStoreCache.multiQuery(vertexIds, query, tx);
    }

    public void assignID(InternalElement vertex) {
        this.idAssigner.assignID(vertex);
    }

    public void commit(final Collection<InternalRelation> addedRelations, final Collection<InternalRelation> deletedRelations, final StandardTitanTx tx) {
        log.debug("Saving transaction. Added {}, removed {}", (Object)addedRelations.size(), (Object)deletedRelations.size());
        final BackendTransaction mutator = tx.getTxHandle();
        final boolean acquireLocks = tx.getConfiguration().hasAcquireLocks();
        if (!tx.getConfiguration().hasAssignIDsImmediately()) {
            this.idAssigner.assignIDs(addedRelations);
        }
        Callable<List<StaticBuffer>> persist = new Callable<List<StaticBuffer>>(){

            @Override
            public List<StaticBuffer> call() throws Exception {
                ArrayListMultimap mutations = ArrayListMultimap.create();
                if (deletedRelations != null && !deletedRelations.isEmpty()) {
                    for (InternalRelation del : deletedRelations) {
                        Preconditions.checkArgument((boolean)del.isRemoved());
                        for (int pos = 0; pos < del.getLen(); ++pos) {
                            InternalVertex vertex = del.getVertex(pos);
                            if (pos == 0 || !del.isLoop()) {
                                mutations.put((Object)vertex, (Object)del);
                            }
                            Direction dir = EdgeDirection.fromPosition(pos);
                            if (!acquireLocks || !del.getType().isUnique(dir) || !((InternalType)del.getType()).uniqueLock(dir)) continue;
                            Entry entry = StandardTitanGraph.this.edgeSerializer.writeRelation(del, pos, tx);
                            mutator.acquireEdgeLock(IDHandler.getKey(vertex.getID()), entry.getColumn(), entry.getValue());
                        }
                        if (!del.isProperty() || !acquireLocks) continue;
                        StandardTitanGraph.this.indexSerializer.lockKeyedProperty((TitanProperty)((Object)del), mutator);
                    }
                }
                ArrayListMultimap otherEdgeTypes = ArrayListMultimap.create();
                for (InternalRelation relation : addedRelations) {
                    Preconditions.checkArgument((boolean)relation.isNew());
                    TitanType type = relation.getType();
                    if (SystemTypeManager.prepersistedSystemTypes.contains(type)) {
                        InternalType itype = (InternalType)relation.getVertex(0);
                        otherEdgeTypes.put((Object)itype, (Object)relation);
                    } else {
                        for (int pos = 0; pos < relation.getLen(); ++pos) {
                            InternalVertex vertex = relation.getVertex(pos);
                            if (pos == 0 || !relation.isLoop()) {
                                mutations.put((Object)vertex, (Object)relation);
                            }
                            Direction dir = EdgeDirection.fromPosition(pos);
                            if (!acquireLocks || !relation.getType().isUnique(dir) || vertex.isNew() || !((InternalType)relation.getType()).uniqueLock(dir)) continue;
                            Entry entry = StandardTitanGraph.this.edgeSerializer.writeRelation(relation, pos, tx);
                            mutator.acquireEdgeLock(IDHandler.getKey(vertex.getID()), entry.getColumn(), null);
                        }
                    }
                    if (!relation.isProperty() || !acquireLocks) continue;
                    StandardTitanGraph.this.indexSerializer.lockKeyedProperty((TitanProperty)((Object)relation), mutator);
                }
                ArrayList<StaticBuffer> mutatedVertexKeys = new ArrayList<StaticBuffer>();
                if (!otherEdgeTypes.isEmpty()) {
                    mutatedVertexKeys.addAll(StandardTitanGraph.this.persist((ListMultimap)otherEdgeTypes, tx));
                    mutator.flush();
                    for (InternalType itype : otherEdgeTypes.keySet()) {
                        if (!itype.isPropertyKey() || !itype.isNew()) continue;
                        StandardTitanGraph.this.indexSerializer.newPropertyKey((TitanKey)((Object)itype), mutator);
                    }
                }
                if (!mutations.isEmpty()) {
                    mutatedVertexKeys.addAll(StandardTitanGraph.this.persist((ListMultimap)mutations, tx));
                }
                mutator.commit();
                return mutatedVertexKeys;
            }

            public String toString() {
                return "PersistingTransaction";
            }
        };
        List<StaticBuffer> mutatedVertexKeys = BackendOperation.execute(persist, this.maxWriteRetryAttempts, this.retryStorageWaitTime);
        for (StaticBuffer vertexKey : mutatedVertexKeys) {
            this.edgeStoreCache.invalidate(vertexKey);
        }
    }

    private <V extends InternalVertex> List<StaticBuffer> persist(ListMultimap<V, InternalRelation> mutatedEdges, StandardTitanTx tx) throws StorageException {
        assert (mutatedEdges != null && !mutatedEdges.isEmpty());
        Set vertices = mutatedEdges.keySet();
        BackendTransaction mutator = tx.getTxHandle();
        ArrayList<StaticBuffer> mutatedKeys = new ArrayList<StaticBuffer>(vertices.size());
        for (InternalVertex vertex : vertices) {
            Preconditions.checkArgument((vertex.getID() > 0L ? 1 : 0) != 0, (String)"Vertex has no id: %s", (Object[])new Object[]{vertex.getID()});
            List edges = mutatedEdges.get((Object)vertex);
            ArrayList<Entry> additions = new ArrayList<Entry>(edges.size());
            ArrayList<StaticBuffer> deletions = new ArrayList<StaticBuffer>(Math.max(10, edges.size() / 10));
            for (InternalRelation edge : edges) {
                for (int pos = 0; pos < edge.getLen(); ++pos) {
                    if (!edge.getVertex(pos).equals(vertex)) continue;
                    if (edge.isRemoved()) {
                        deletions.add(this.edgeSerializer.writeRelation(edge, pos, tx).getColumn());
                        continue;
                    }
                    Preconditions.checkArgument((boolean)edge.isNew());
                    additions.add(this.edgeSerializer.writeRelation(edge, pos, tx));
                }
            }
            StaticBuffer vertexKey = IDHandler.getKey(vertex.getID());
            mutator.mutateEdges(vertexKey, additions, deletions);
            if (!vertex.isNew()) {
                mutatedKeys.add(vertexKey);
            }
            for (InternalRelation relation : edges) {
                if (!relation.getVertex(0).equals(vertex)) continue;
                if (relation.isRemoved()) {
                    if (relation.isProperty()) {
                        this.indexSerializer.removeProperty((TitanProperty)((Object)relation), mutator);
                        continue;
                    }
                    if (!relation.isEdge()) continue;
                    this.indexSerializer.removeEdge(relation, mutator);
                    continue;
                }
                Preconditions.checkArgument((boolean)relation.isNew());
                if (relation.isProperty()) {
                    this.indexSerializer.addProperty((TitanProperty)((Object)relation), mutator);
                    continue;
                }
                this.indexSerializer.addEdge(relation, mutator);
            }
        }
        return mutatedKeys;
    }
}

