/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.cache;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.cache.StoreCache;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationStoreCache
implements StoreCache {
    private static final Logger log = LoggerFactory.getLogger(ExpirationStoreCache.class);
    private static final int STATICARRAYBUFFER_SIZE = 64;
    private static final int KEY_QUERY_SIZE = 233;
    private static final int INVALIDATE_KEY_FRACTION_PENALTY = 1000;
    private static final int PENALTY_THRESHOLD = 5;
    private static final String METRICS_PREFIX = "com.thinkaurelius.titan.sys." + ExpirationStoreCache.class.getSimpleName();
    private static final Counter GLOBAL_CACHE_MISSES = MetricManager.INSTANCE.getCounter(METRICS_PREFIX, "misses");
    private static final Counter GLOBAL_CACHE_RETRIEVALS = MetricManager.INSTANCE.getCounter(METRICS_PREFIX, "retrievals");
    private volatile CountDownLatch penaltyCountdown;
    private final Cache<KeySliceQuery, List<Entry>> cache;
    private final ConcurrentHashMap<StaticBuffer, Long> expiredKeys;
    private final long cacheTimeMS;
    private final long expirationGracePeriodMS;
    private final CleanupThread cleanupThread;

    public ExpirationStoreCache(long cacheTimeMS, long expirationGracePeriodMS, long maximumByteSize) {
        Preconditions.checkArgument((cacheTimeMS > 0L ? 1 : 0) != 0, (Object)"Cache expiration must be positive: %s");
        Preconditions.checkArgument((System.currentTimeMillis() + 3153600000000L + cacheTimeMS > 0L ? 1 : 0) != 0, (String)"Cache expiration time too large, overflow may occur: %s", (Object[])new Object[]{cacheTimeMS});
        this.cacheTimeMS = cacheTimeMS;
        int concurrencyLevel = Runtime.getRuntime().availableProcessors();
        Preconditions.checkArgument((expirationGracePeriodMS >= 0L ? 1 : 0) != 0, (String)"Invalid expiration grace peiod: %s", (Object[])new Object[]{expirationGracePeriodMS});
        this.expirationGracePeriodMS = expirationGracePeriodMS;
        CacheBuilder cachebuilder = CacheBuilder.newBuilder().maximumWeight(maximumByteSize).concurrencyLevel(concurrencyLevel).initialCapacity(1000).expireAfterWrite(cacheTimeMS, TimeUnit.MILLISECONDS).weigher((Weigher)new Weigher<KeySliceQuery, List<Entry>>(){

            public int weigh(KeySliceQuery keySliceQuery, List<Entry> entries) {
                int size = 379;
                for (Entry e : entries) {
                    size += e.getByteSize();
                }
                return size;
            }
        });
        this.cache = cachebuilder.build();
        this.expiredKeys = new ConcurrentHashMap(50, 0.75f, concurrencyLevel);
        this.penaltyCountdown = new CountDownLatch(5);
        this.cleanupThread = new CleanupThread();
        this.cleanupThread.start();
    }

    public static void resetGlobablCounts() {
        GLOBAL_CACHE_MISSES.dec(GLOBAL_CACHE_MISSES.getCount());
        GLOBAL_CACHE_RETRIEVALS.dec(GLOBAL_CACHE_RETRIEVALS.getCount());
    }

    public static long getGlobalCacheRetrievals() {
        return GLOBAL_CACHE_RETRIEVALS.getCount();
    }

    public static long getGlobalCacheMisses() {
        return GLOBAL_CACHE_MISSES.getCount();
    }

    public static long getGlobalCacheHits() {
        return ExpirationStoreCache.getGlobalCacheRetrievals() - ExpirationStoreCache.getGlobalCacheMisses();
    }

    private boolean isExpired(KeySliceQuery query) {
        Long until = this.expiredKeys.get(query.getKey());
        if (until == null) {
            return false;
        }
        if (this.isBeyondExpirationTime(until)) {
            this.expiredKeys.remove(query.getKey(), until);
            return false;
        }
        this.penaltyCountdown.countDown();
        return true;
    }

    @Override
    public List<Entry> query(final KeySliceQuery query, final BackendTransaction tx) {
        if (this.isExpired(query)) {
            return tx.edgeStoreQuery(query);
        }
        try {
            GLOBAL_CACHE_RETRIEVALS.inc();
            return (List)this.cache.get((Object)query, (Callable)new Callable<List<Entry>>(){

                @Override
                public List<Entry> call() throws Exception {
                    GLOBAL_CACHE_MISSES.inc();
                    return tx.edgeStoreQuery(query);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof TitanException) {
                throw (TitanException)e;
            }
            if (e.getCause() instanceof TitanException) {
                throw (TitanException)e.getCause();
            }
            throw new TitanException(e);
        }
    }

    @Override
    public List<List<Entry>> multiQuery(List<StaticBuffer> keys, SliceQuery query, BackendTransaction tx) {
        List[] results = new List[keys.size()];
        ArrayList<StaticBuffer> remainingKeys = new ArrayList<StaticBuffer>(keys.size());
        KeySliceQuery[] ksqs = new KeySliceQuery[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            StaticBuffer key = keys.get(i);
            ksqs[i] = new KeySliceQuery(key, query);
            List result = null;
            if (!this.isExpired(ksqs[i])) {
                result = (List)this.cache.getIfPresent((Object)ksqs[i]);
            } else {
                ksqs[i] = null;
            }
            if (result != null) {
                results[i] = result;
                continue;
            }
            remainingKeys.add(key);
        }
        List<List<Entry>> subresults = tx.edgeStoreMultiQuery(remainingKeys, query);
        int pos = 0;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] != null) continue;
            assert (pos < subresults.size());
            List<Entry> subresult = subresults.get(pos);
            assert (subresult != null);
            results[i] = subresult;
            if (ksqs[i] != null) {
                this.cache.put((Object)ksqs[i], subresult);
            }
            ++pos;
        }
        assert (pos == subresults.size());
        return Arrays.asList(results);
    }

    private final long getExpirationTime() {
        return System.currentTimeMillis() + this.cacheTimeMS;
    }

    private final boolean isBeyondExpirationTime(long until) {
        return until < System.currentTimeMillis();
    }

    private final long getAge(long until) {
        long age = System.currentTimeMillis() - (until - this.cacheTimeMS);
        assert (age >= 0L);
        return age;
    }

    @Override
    public void invalidate(StaticBuffer key) {
        this.expiredKeys.put(key, this.getExpirationTime());
        if (Math.random() < 0.001) {
            this.penaltyCountdown.countDown();
        }
    }

    @Override
    public void close() {
        this.cleanupThread.stopThread();
    }

    private class CleanupThread
    extends Thread {
        private boolean stop = false;

        public CleanupThread() {
            this.setDaemon(true);
            this.setName("ExpirationStoreCache-" + this.getId());
        }

        @Override
        public void run() {
            block2: while (!this.stop) {
                try {
                    ExpirationStoreCache.this.penaltyCountdown.await();
                }
                catch (InterruptedException e) {
                    if (this.stop) {
                        return;
                    }
                    throw new RuntimeException("Cleanup thread got interrupted", e);
                }
                HashMap expiredKeysCopy = new HashMap(ExpirationStoreCache.this.expiredKeys.size());
                for (Map.Entry expKey : ExpirationStoreCache.this.expiredKeys.entrySet()) {
                    if (ExpirationStoreCache.this.isBeyondExpirationTime((Long)expKey.getValue())) {
                        ExpirationStoreCache.this.expiredKeys.remove(expKey.getKey(), expKey.getValue());
                        continue;
                    }
                    if (ExpirationStoreCache.this.getAge((Long)expKey.getValue()) < ExpirationStoreCache.this.expirationGracePeriodMS) continue;
                    expiredKeysCopy.put(expKey.getKey(), expKey.getValue());
                }
                for (KeySliceQuery ksq : ExpirationStoreCache.this.cache.asMap().keySet()) {
                    if (!expiredKeysCopy.containsKey(ksq.getKey())) continue;
                    ExpirationStoreCache.this.cache.invalidate((Object)ksq);
                }
                ExpirationStoreCache.this.penaltyCountdown = new CountDownLatch(5);
                Iterator i$ = expiredKeysCopy.entrySet().iterator();
                while (true) {
                    Map.Entry expKey;
                    if (!i$.hasNext()) continue block2;
                    expKey = i$.next();
                    ExpirationStoreCache.this.expiredKeys.remove(expKey.getKey(), expKey.getValue());
                }
                break;
            }
            return;
        }

        void stopThread() {
            this.stop = true;
            this.interrupt();
        }
    }
}

