/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner;

import cern.colt.list.ObjectArrayList;
import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanType;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPool;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import com.thinkaurelius.titan.graphdb.database.idassigner.StandardIDPool;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.DefaultPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.IDPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionAssignment;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexIDAssigner {
    private static final Logger log = LoggerFactory.getLogger(VertexIDAssigner.class);
    private static final Object EXHAUSTED_ID_POOL = new Object();
    private static final int DEFAULT_PARTITION_BITS = 30;
    private static final int MAX_PARTITION_RENEW_ATTEMPTS = 1000;
    private static final int DEFAULT_PARTITION = 0;
    final AbstractIntObjectMap idPools;
    final ReadWriteLock idPoolsLock;
    private final IDAuthority idAuthority;
    private final IDManager idManager;
    private final IDPlacementStrategy placementStrategy;
    private final long renewTimeoutMS;
    private final double renewBufferPercentage;
    private final int maxPartitionID;
    private final boolean hasLocalPartitions;

    public VertexIDAssigner(Configuration config, IDAuthority idAuthority, StoreFeatures idAuthFeatures) {
        long partitionBits;
        Preconditions.checkNotNull((Object)idAuthority);
        this.idAuthority = idAuthority;
        boolean partitionIDs = config.getBoolean("partition", false);
        if (partitionIDs) {
            partitionBits = 30L;
            this.hasLocalPartitions = idAuthFeatures.hasLocalKeyPartition();
            this.placementStrategy = new SimpleBulkPlacementStrategy(config);
        } else {
            if (idAuthFeatures.isKeyOrdered() && idAuthFeatures.isDistributed()) {
                log.warn("ID Partitioning is disabled which will likely cause uneven data distribution");
            }
            partitionBits = 0L;
            this.hasLocalPartitions = false;
            this.placementStrategy = new DefaultPlacementStrategy(0);
        }
        log.debug("Partition IDs? [{}], Local Partitions? [{}]", (Object)partitionIDs, (Object)this.hasLocalPartitions);
        this.idManager = new IDManager(partitionBits);
        Preconditions.checkArgument((this.idManager.getMaxPartitionCount() < Integer.MAX_VALUE ? 1 : 0) != 0);
        this.maxPartitionID = (int)this.idManager.getMaxPartitionCount();
        long baseBlockSize = config.getLong("block-size", 10000L);
        idAuthority.setIDBlockSizer(new SimpleVertexIDBlockSizer(baseBlockSize));
        this.renewTimeoutMS = config.getLong("renew-timeout", 60000L);
        this.renewBufferPercentage = config.getDouble("renew-percentage", 0.3);
        this.idPools = new OpenIntObjectHashMap();
        this.idPoolsLock = new ReentrantReadWriteLock();
        this.setLocalPartitions();
    }

    private void setLocalPartitions() {
        if (!this.hasLocalPartitions) {
            this.placementStrategy.setLocalPartitionBounds(0, this.maxPartitionID + 1, this.maxPartitionID + 1);
        } else {
            StaticBuffer[] local = null;
            try {
                local = this.idAuthority.getLocalIDPartition();
            }
            catch (Exception e) {
                log.error("Could not read local id partition: {}", (Throwable)e);
                this.placementStrategy.setLocalPartitionBounds(0, this.maxPartitionID + 1, this.maxPartitionID + 1);
            }
            if (local != null) {
                Preconditions.checkArgument((local[0].length() >= 4 && local[1].length() >= 4 ? 1 : 0) != 0);
                int[] partition = new int[2];
                for (int i = 0; i < 2; ++i) {
                    partition[i] = local[i].getInt(0);
                }
                partition[0] = (partition[0] & 3) > 0 ? (partition[0] >>> 2) + 1 : partition[0] >>> 2;
                partition[1] = (partition[1] >>> 2) - 1;
                Preconditions.checkArgument((partition[0] != partition[1] ? 1 : 0) != 0);
                log.info("Setting partition bound [{},{}]", (Object)partition[0], (Object)partition[1]);
                this.placementStrategy.setLocalPartitionBounds(partition[0], partition[1], this.maxPartitionID + 1);
            }
        }
    }

    public IDManager getIDManager() {
        return this.idManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.idPoolsLock.writeLock().lock();
        try {
            ObjectArrayList pools = this.idPools.values();
            for (int i = 0; i < pools.size(); ++i) {
                ((PartitionPool)pools.get(i)).close();
            }
            this.idPools.clear();
        }
        finally {
            this.idPoolsLock.writeLock().unlock();
        }
    }

    public void assignID(InternalElement vertex) {
        for (int attempt = 0; attempt < 1000; ++attempt) {
            long partitionID = -1L;
            partitionID = vertex instanceof InternalRelation ? (long)this.placementStrategy.getPartition(vertex) : (vertex instanceof TitanType ? 0L : (long)this.placementStrategy.getPartition(vertex));
            try {
                this.assignID(vertex, partitionID);
                return;
            }
            catch (IDPoolExhaustedException e) {
                continue;
            }
        }
        throw new IDPoolExhaustedException("Could not find non-exhausted partition ID Pool after 1000 attempts");
    }

    public void assignIDs(Iterable<InternalRelation> addedRelations) {
        if (!this.placementStrategy.supportsBulkPlacement()) {
            for (InternalRelation relation : addedRelations) {
                for (int i = 0; i < relation.getArity(); ++i) {
                    InternalVertex vertex = relation.getVertex(i);
                    if (vertex.hasId()) continue;
                    this.assignID(vertex);
                }
                this.assignID(relation);
            }
        } else {
            HashMap<InternalVertex, PartitionAssignment> assignments = new HashMap<InternalVertex, PartitionAssignment>();
            for (InternalRelation relation : addedRelations) {
                for (int i = 0; i < relation.getArity(); ++i) {
                    InternalVertex vertex = relation.getVertex(i);
                    if (vertex.hasId()) continue;
                    if (vertex instanceof TitanType) {
                        this.assignID(vertex, 0L);
                        continue;
                    }
                    assignments.put(vertex, PartitionAssignment.EMPTY);
                }
            }
            log.trace("Bulk id assignment for {} vertices", (Object)assignments.size());
            for (int attempt = 0; attempt < 1000 && assignments != null && !assignments.isEmpty(); ++attempt) {
                this.placementStrategy.getPartitions(assignments);
                HashMap leftOvers = null;
                Iterator iter = assignments.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    try {
                        this.assignID((InternalElement)entry.getKey(), ((PartitionAssignment)entry.getValue()).getPartitionID());
                        Preconditions.checkArgument((boolean)((InternalVertex)entry.getKey()).hasId());
                    }
                    catch (IDPoolExhaustedException e) {
                        if (leftOvers == null) {
                            leftOvers = new HashMap();
                        }
                        leftOvers.put(entry.getKey(), PartitionAssignment.EMPTY);
                        break;
                    }
                }
                if (leftOvers != null) {
                    while (iter.hasNext()) {
                        leftOvers.put(iter.next().getKey(), PartitionAssignment.EMPTY);
                    }
                    log.debug("Exhausted ID Pool in bulk assignment. Left-over vertices {}", (Object)leftOvers.size());
                }
                assignments = leftOvers;
            }
            if (assignments != null && !assignments.isEmpty()) {
                throw new IDPoolExhaustedException("Could not find non-exhausted partition ID Pool after 1000 attempts");
            }
            for (InternalRelation relation : addedRelations) {
                for (int pos = 0; pos < relation.getArity(); ++pos) {
                    try {
                        Preconditions.checkArgument((boolean)relation.getVertex(pos).hasId());
                        this.assignID(relation, this.getPartitionID(relation.getVertex(pos)));
                        break;
                    }
                    catch (IDPoolExhaustedException e) {
                        continue;
                    }
                }
                if (relation.hasId()) continue;
                this.assignID(relation);
            }
        }
    }

    private final long getPartitionID(InternalVertex v) {
        long vid = v.getID();
        if (IDManager.IDType.TitanType.is(vid)) {
            return 0L;
        }
        return this.idManager.getPartitionID(vid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignID(InternalElement vertex, long partitionIDl) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkArgument((!vertex.hasId() ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionIDl >= 0L && partitionIDl <= (long)this.maxPartitionID ? 1 : 0) != 0, (Object)partitionIDl);
        int partitionID = (int)partitionIDl;
        long id = -1L;
        Object poolObj = null;
        this.idPoolsLock.readLock().lock();
        try {
            poolObj = this.idPools.get(partitionID);
        }
        finally {
            this.idPoolsLock.readLock().unlock();
        }
        if (poolObj == null) {
            this.idPoolsLock.writeLock().lock();
            try {
                if (this.idPools.containsKey(partitionID)) {
                    poolObj = this.idPools.get(partitionID);
                } else {
                    poolObj = new PartitionPool(partitionID, this.idAuthority, this.idManager, partitionID == 0, this.renewTimeoutMS, this.renewBufferPercentage);
                    this.idPools.put(partitionID, poolObj);
                }
            }
            finally {
                this.idPoolsLock.writeLock().unlock();
            }
        }
        Preconditions.checkNotNull((Object)poolObj);
        if (poolObj == EXHAUSTED_ID_POOL) {
            this.placementStrategy.exhaustedPartition(partitionID);
            throw new IDPoolExhaustedException("Exhausted id pool for partition: " + partitionID);
        }
        PartitionPool pool = (PartitionPool)poolObj;
        try {
            id = vertex instanceof InternalRelation ? this.idManager.getRelationID(pool.relation.nextID(), partitionID) : (vertex instanceof TitanKey ? IDManager.getPropertyKeyID(pool.relationType.nextID() + 8L) : (vertex instanceof TitanLabel ? IDManager.getEdgeLabelID(pool.relationType.nextID() + 8L) : this.idManager.getVertexID(pool.vertex.nextID(), partitionID)));
            pool.accessed();
        }
        catch (IDPoolExhaustedException e) {
            log.debug("Pool exhausted for partition id {}", (Object)partitionID);
            this.placementStrategy.exhaustedPartition(partitionID);
            this.idPoolsLock.writeLock().lock();
            try {
                this.idPools.put(partitionID, EXHAUSTED_ID_POOL);
                pool.close();
            }
            finally {
                this.idPoolsLock.writeLock().unlock();
            }
            throw e;
        }
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0);
        vertex.setID(id);
    }

    private static enum PoolType {
        VERTEX,
        RELATION,
        RELATIONTYPE;


        private int getID() {
            switch (this) {
                case VERTEX: {
                    return 1;
                }
                case RELATION: {
                    return 2;
                }
                case RELATIONTYPE: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Unrecognized PoolType: " + (Object)((Object)this));
        }

        public int getFullPartitionID(int partitionID) {
            Preconditions.checkArgument((partitionID < 0x40000000 ? 1 : 0) != 0, (Object)partitionID);
            return partitionID << 2 | this.getID();
        }

        public static int getPartitionID(int fullPartitionID) {
            return fullPartitionID >>> 2;
        }

        public static PoolType getPoolType(int fullPartitionID) {
            switch (fullPartitionID & 3) {
                case 1: {
                    return VERTEX;
                }
                case 2: {
                    return RELATION;
                }
                case 3: {
                    return RELATIONTYPE;
                }
            }
            throw new IllegalArgumentException("Unrecognized partition id: " + fullPartitionID);
        }
    }

    private static class PartitionPool {
        final IDPool vertex;
        final IDPool relation;
        final IDPool relationType;
        long lastAccess;

        PartitionPool(int partitionID, IDAuthority idAuthority, IDManager idManager, boolean includeRelationType, long renewTimeoutMS, double renewBufferPercentage) {
            this.vertex = new StandardIDPool(idAuthority, PoolType.VERTEX.getFullPartitionID(partitionID), idManager.getMaxVertexCount(), renewTimeoutMS, renewBufferPercentage);
            this.relation = new StandardIDPool(idAuthority, PoolType.RELATION.getFullPartitionID(partitionID), idManager.getMaxRelationCount(), renewTimeoutMS, renewBufferPercentage);
            this.relationType = includeRelationType ? new StandardIDPool(idAuthority, PoolType.RELATIONTYPE.getFullPartitionID(partitionID), idManager.getMaxTitanTypeCount(), renewTimeoutMS, renewBufferPercentage) : null;
        }

        public void close() {
            this.vertex.close();
            this.relation.close();
            if (this.relationType != null) {
                this.relationType.close();
            }
        }

        public void accessed() {
            this.lastAccess = System.currentTimeMillis();
        }
    }

    private class SimpleVertexIDBlockSizer
    implements IDBlockSizer {
        private static final int AVG_EDGES_PER_VERTEX = 10;
        private static final int DEFAULT_NUM_EDGE_TYPES = 12;
        private final long baseBlockSize;

        SimpleVertexIDBlockSizer(long size) {
            Preconditions.checkArgument((size > 0L && size < Integer.MAX_VALUE ? 1 : 0) != 0);
            this.baseBlockSize = size;
        }

        @Override
        public long getBlockSize(int fullPartitionID) {
            switch (PoolType.getPoolType(fullPartitionID)) {
                case VERTEX: {
                    return this.baseBlockSize;
                }
                case RELATION: {
                    return this.baseBlockSize * 10L;
                }
                case RELATIONTYPE: {
                    return 12L;
                }
            }
            throw new IllegalArgumentException("Unrecognized pool type");
        }

        @Override
        public long getIdUpperBound(int fullPartitionID) {
            switch (PoolType.getPoolType(fullPartitionID)) {
                case VERTEX: {
                    return VertexIDAssigner.this.idManager.getMaxVertexCount() + 1L;
                }
                case RELATION: {
                    return VertexIDAssigner.this.idManager.getMaxRelationCount() + 1L;
                }
                case RELATIONTYPE: {
                    return VertexIDAssigner.this.idManager.getMaxTitanTypeCount() + 1L;
                }
            }
            throw new IllegalArgumentException("Unrecognized pool type");
        }
    }
}

