/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idhandling;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.RelationType;

public class IDHandler {
    public static final StaticBuffer MIN_KEY = ByteBufferUtil.getLongBuffer(0L);
    public static final StaticBuffer MAX_KEY = ByteBufferUtil.getLongBuffer(-1L);
    private static final int PREFIX_BIT_LEN = 2;
    public static final int PROPERTY_DIR = 0;
    public static final int EDGE_OUT_DIR = 2;
    public static final int EDGE_IN_DIR = 3;

    public static StaticBuffer getKey(long id) {
        assert (id >= 0L);
        return ByteBufferUtil.getLongBuffer(id << 1);
    }

    public static long getKeyID(StaticBuffer b) {
        long value = b.getLong(0);
        return value >>> 1;
    }

    private static int getDirection(int dirID) {
        return dirID & 1;
    }

    private static int getRelationType(int dirID) {
        return dirID >>> 1;
    }

    private static int getDirectionID(int relationType, int direction) {
        assert (relationType >= 0 && relationType <= 1 && direction >= 0 && direction <= 1);
        return (relationType << 1) + direction;
    }

    public static boolean isValidDirection(int dirId) {
        return dirId == 0 || dirId == 3 || dirId == 2;
    }

    public static int edgeTypeLength(long etid) {
        assert (etid > 0L && etid << 1 > 0L);
        return VariableLong.positiveWithPrefixLength(IDManager.getTypeCount(etid) << 1, 2);
    }

    public static void writeEdgeType(WriteBuffer out, long etid, int dirID) {
        assert (etid > 0L && etid << 1 > 0L);
        assert (IDHandler.isValidDirection(dirID));
        etid = (IDManager.getTypeCount(etid) << 1) + (long)IDHandler.getDirection(dirID);
        VariableLong.writePositiveWithPrefix(out, etid, IDHandler.getRelationType(dirID), 2);
    }

    public static StaticBuffer getEdgeType(long etid, int dirID) {
        WriteByteBuffer b = new WriteByteBuffer(IDHandler.edgeTypeLength(etid));
        IDHandler.writeEdgeType(b, etid, dirID);
        return b.getStaticBuffer();
    }

    public static long[] readEdgeType(ReadBuffer in) {
        long[] countPrefix = VariableLong.readPositiveWithPrefix(in, 2);
        int dirID = IDHandler.getDirectionID((int)countPrefix[1], (int)(countPrefix[0] & 1L));
        countPrefix[1] = dirID;
        countPrefix[0] = countPrefix[0] >>> 1;
        if (countPrefix[1] == 0L) {
            countPrefix[0] = IDManager.getPropertyKeyID(countPrefix[0]);
        } else if (countPrefix[1] == 3L || countPrefix[1] == 2L) {
            countPrefix[0] = IDManager.getEdgeLabelID(countPrefix[0]);
        } else {
            throw new AssertionError((Object)("Invalid direction ID: " + countPrefix[1]));
        }
        return countPrefix;
    }

    public static void writeInlineEdgeType(WriteBuffer out, long etid) {
        long compressId = IDManager.getTypeCount(etid) << 1;
        if (IDManager.isPropertyKeyID(etid)) {
            compressId += 0L;
        } else if (IDManager.isEdgeLabelID(etid)) {
            ++compressId;
        } else {
            throw new AssertionError((Object)("Invalid type id: " + etid));
        }
        VariableLong.writePositive(out, compressId);
    }

    public static long readInlineEdgeType(ReadBuffer in) {
        long compressId = VariableLong.readPositive(in);
        long id = compressId >>> 1;
        switch ((int)(compressId & 1L)) {
            case 0: {
                id = IDManager.getPropertyKeyID(id);
                break;
            }
            case 1: {
                id = IDManager.getEdgeLabelID(id);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid type: " + compressId));
            }
        }
        return id;
    }

    private static StaticBuffer getPrefixed(int prefix) {
        assert (prefix < 4 && prefix >= 0);
        byte[] arr = new byte[]{(byte)(prefix << 6)};
        return new StaticArrayBuffer(arr);
    }

    public static StaticBuffer[] getBounds(RelationType type) {
        int end;
        int start;
        switch (type) {
            case PROPERTY: {
                start = IDHandler.getRelationType(0);
                end = start + 1;
                break;
            }
            case EDGE: {
                start = IDHandler.getRelationType(2);
                end = start + 1;
                break;
            }
            case RELATION: {
                start = IDHandler.getRelationType(0);
                end = IDHandler.getRelationType(2) + 1;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized type:" + type));
            }
        }
        assert (end > start);
        return new StaticBuffer[]{IDHandler.getPrefixed(start), IDHandler.getPrefixed(end)};
    }
}

