/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.LongSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleSerializer
implements AttributeSerializer<Double> {
    private static final Logger log = LoggerFactory.getLogger(DoubleSerializer.class);
    private static final long serialVersionUID = -1719511496523862718L;
    public static final int DECIMALS = 6;
    private static int MULTIPLIER = 0;
    public static final double MIN_VALUE;
    public static final double MAX_VALUE;
    private final LongSerializer ls = new LongSerializer();

    @Override
    public Double read(ScanBuffer buffer) {
        long longvalue = this.ls.read(buffer);
        return DoubleSerializer.convert(longvalue);
    }

    @Override
    public void writeObjectData(WriteBuffer out, Double object) {
        Preconditions.checkArgument((boolean)DoubleSerializer.withinRange(object), (String)"Double value is out of range: %s", (Object[])new Object[]{object});
        assert (object * (double)MULTIPLIER >= -9.223372036854776E18 && object * (double)MULTIPLIER <= 9.223372036854776E18);
        long convert = DoubleSerializer.convert(object);
        this.ls.writeObjectData(out, convert);
    }

    public static final long convert(Double object) {
        return (long)(object * (double)MULTIPLIER);
    }

    public static final double convert(long value) {
        return (double)value / (double)MULTIPLIER;
    }

    public static final boolean withinRange(Double object) {
        return object >= MIN_VALUE && object <= MAX_VALUE;
    }

    @Override
    public void verifyAttribute(Double value) {
        Preconditions.checkArgument((!Double.isNaN(value) ? 1 : 0) != 0, (Object)"Value may not be NaN");
        Preconditions.checkArgument((boolean)DoubleSerializer.withinRange(value), (String)"Value out of range [%s,%s]: %s. Use FullDouble instead.", (Object[])new Object[]{MIN_VALUE, MAX_VALUE, value});
        if (DoubleSerializer.convert(DoubleSerializer.convert(value)) != value) {
            log.warn("Truncated decimals of double value: {}. Use FullDouble for full precision.", (Object)value);
        }
    }

    @Override
    public Double convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        return null;
    }

    static {
        MULTIPLIER = 1;
        for (int i = 0; i < 6; ++i) {
            MULTIPLIER *= 10;
        }
        MIN_VALUE = -9.223372036854776E18 / (double)(MULTIPLIER + 1);
        MAX_VALUE = 9.223372036854776E18 / (double)(MULTIPLIER + 1);
    }
}

