/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.LongSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatSerializer
implements AttributeSerializer<Float> {
    private static final Logger log = LoggerFactory.getLogger(FloatSerializer.class);
    private static final long serialVersionUID = -1719511423423862718L;
    public static final int DECIMALS = 3;
    private static int MULTIPLIER = 0;
    public static final float MIN_VALUE;
    public static final float MAX_VALUE;
    private final LongSerializer ls = new LongSerializer();

    @Override
    public Float read(ScanBuffer buffer) {
        long longvalue = this.ls.read(buffer);
        return Float.valueOf(FloatSerializer.convert(longvalue));
    }

    @Override
    public void writeObjectData(WriteBuffer out, Float object) {
        Preconditions.checkArgument((boolean)FloatSerializer.withinRange(object), (String)"Float value is out of range: %s", (Object[])new Object[]{object});
        assert (object.floatValue() * (float)MULTIPLIER >= -9.223372E18f && object.floatValue() * (float)MULTIPLIER <= 9.223372E18f);
        long convert = FloatSerializer.convert(object);
        this.ls.writeObjectData(out, convert);
    }

    public static final long convert(Float object) {
        return (long)(object.floatValue() * (float)MULTIPLIER);
    }

    public static final float convert(long value) {
        return (float)value / (float)MULTIPLIER;
    }

    public static final boolean withinRange(Float object) {
        return object.floatValue() >= MIN_VALUE && object.floatValue() <= MAX_VALUE;
    }

    @Override
    public void verifyAttribute(Float value) {
        Preconditions.checkArgument((!Float.isNaN(value.floatValue()) ? 1 : 0) != 0, (Object)"Value may not be NaN");
        Preconditions.checkArgument((boolean)FloatSerializer.withinRange(value), (String)"Value out of range [%s,%s]: %s. Use FullFloat instead.", (Object[])new Object[]{Float.valueOf(MIN_VALUE), Float.valueOf(MAX_VALUE), value});
        if (FloatSerializer.convert(FloatSerializer.convert(value)) != value.floatValue()) {
            log.warn("Truncated decimals of float value: {}. Use FullFloat for full precision.", (Object)value);
        }
    }

    @Override
    public Float convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d < (double)1.4E-45f || d > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value too large for float: " + value);
            }
            return Float.valueOf((float)d);
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    static {
        MULTIPLIER = 1;
        for (int i = 0; i < 3; ++i) {
            MULTIPLIER *= 10;
        }
        MIN_VALUE = (float)(-9.223372036854776E18 / (double)(MULTIPLIER + 1));
        MAX_VALUE = (float)(9.223372036854776E18 / (double)(MULTIPLIER + 1));
    }
}

