/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.core.attribute.FullFloat;

public class FullFloatHandler
implements AttributeHandler<FullFloat> {
    @Override
    public void verifyAttribute(FullFloat value) {
    }

    @Override
    public FullFloat convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d < (double)1.4E-45f || d > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value too large for float: " + value);
            }
            return new FullFloat((float)d);
        }
        if (value instanceof String) {
            return new FullFloat(Float.parseFloat((String)value));
        }
        return null;
    }
}

