/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.AttributeHandler;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import java.lang.reflect.Array;

public class GeoshapeHandler
implements AttributeHandler<Geoshape> {
    @Override
    public void verifyAttribute(Geoshape value) {
    }

    @Override
    public Geoshape convert(Object value) {
        if (value.getClass().isArray() && (value.getClass().getComponentType().isPrimitive() || Number.class.isAssignableFrom(value.getClass().getComponentType()))) {
            Geoshape shape = null;
            int len = Array.getLength(value);
            double[] arr = new double[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = ((Number)Array.get(value, i)).doubleValue();
            }
            if (len == 2) {
                shape = Geoshape.point(arr[0], arr[1]);
            } else if (len == 3) {
                shape = Geoshape.circle(arr[0], arr[1], arr[2]);
            } else if (len == 4) {
                shape = Geoshape.box(arr[0], arr[1], arr[2], arr[3]);
            } else {
                throw new IllegalArgumentException("Expected 2-4 coordinates to create Geoshape, but given: " + value);
            }
            return shape;
        }
        if (value instanceof String) {
            String delimiter;
            String[] components = null;
            String[] arr$ = new String[]{",", ";"};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((components = ((String)value).split(delimiter = arr$[i$])).length < 2 || components.length > 4); ++i$) {
                components = null;
            }
            Preconditions.checkArgument((components != null ? 1 : 0) != 0, (String)"Could not parse coordinates from string: %s", (Object[])new Object[]{value});
            double[] coords = new double[components.length];
            try {
                for (int i = 0; i < components.length; ++i) {
                    coords[i] = Double.parseDouble(components[i]);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse coordinates from string: " + value, e);
            }
            return this.convert(coords);
        }
        return null;
    }
}

