/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoSerializer;

public class KryoDataOutput
implements DataOutput {
    private final Output output;
    private final KryoSerializer serializer;
    private final Kryo kryo;

    KryoDataOutput(Output output) {
        this(output, null);
    }

    KryoDataOutput(Output output, KryoSerializer serializer) {
        Preconditions.checkNotNull((Object)output);
        this.output = output;
        this.serializer = serializer;
        this.kryo = serializer != null ? serializer.getKryo() : null;
    }

    @Override
    public DataOutput putLong(long val) {
        this.output.writeLong(val);
        return this;
    }

    @Override
    public DataOutput putInt(int val) {
        this.output.writeInt(val);
        return this;
    }

    @Override
    public DataOutput putShort(short val) {
        this.output.writeShort((int)val);
        return this;
    }

    @Override
    public DataOutput putByte(byte val) {
        this.output.writeByte(val);
        return this;
    }

    @Override
    public DataOutput putChar(char val) {
        this.output.writeChar(val);
        return this;
    }

    @Override
    public DataOutput putFloat(float val) {
        this.output.writeFloat(val);
        return this;
    }

    @Override
    public DataOutput putDouble(double val) {
        this.output.writeDouble(val);
        return this;
    }

    @Override
    public DataOutput writeObject(Object object, Class<?> type) {
        Preconditions.checkArgument((this.serializer != null ? 1 : 0) != 0, (Object)"This DataOutput has not been initialized for object writing!");
        Preconditions.checkArgument((boolean)this.serializer.isValidObject(this.kryo, object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        this.kryo.writeObjectOrNull(this.output, object, type);
        return this;
    }

    @Override
    public DataOutput writeObjectNotNull(Object object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkArgument((this.serializer != null ? 1 : 0) != 0, (Object)"This DataOutput has not been initialized for object writing!");
        Preconditions.checkArgument((boolean)this.serializer.isValidObject(this.kryo, object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        this.kryo.writeObject(this.output, object);
        return this;
    }

    @Override
    public DataOutput writeClassAndObject(Object object) {
        Preconditions.checkArgument((this.serializer != null ? 1 : 0) != 0, (Object)"This DataOutput has not been initialized for object writing!");
        Preconditions.checkArgument((boolean)this.serializer.isValidObject(this.kryo, object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        this.kryo.writeClassAndObject(this.output, object);
        return this;
    }

    @Override
    public int getPosition() {
        return this.output.position();
    }

    @Override
    public StaticBuffer getStaticBuffer() {
        return this.getStaticBufferFlipBytes(0, 0);
    }

    @Override
    public StaticBuffer getStaticBufferFlipBytes(int from, int to) {
        byte[] value = this.output.getBuffer();
        int limit = this.output.position();
        Preconditions.checkArgument((from >= 0 && from <= to ? 1 : 0) != 0);
        Preconditions.checkArgument((to <= limit ? 1 : 0) != 0);
        for (int i = from; i < to; ++i) {
            value[i] = ~value[i];
        }
        return new StaticArrayBuffer(value, 0, limit);
    }
}

