/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.internal;

import com.google.common.primitives.Longs;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;

public abstract class AbstractElement
implements InternalElement {
    protected long id;

    public AbstractElement(long id) {
        assert (id != 0L);
        this.id = id;
    }

    public static boolean isTemporaryId(long elementId) {
        return elementId < 0L;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.getID());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this instanceof TitanVertex && other instanceof TitanVertex) {
            return this.id == ((TitanVertex)other).getID();
        }
        if (this instanceof TitanEdge && other instanceof TitanEdge) {
            return this.id == ((TitanEdge)other).getID();
        }
        return false;
    }

    @Override
    public int compareTo(TitanElement titanElement) {
        return Longs.compare((long)this.getID(), (long)titanElement.getID());
    }

    public InternalVertex clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return !AbstractElement.isTemporaryId(this.getID());
    }

    @Override
    public void setID(long id) {
        assert (AbstractElement.isTemporaryId(this.id));
        assert (id > 0L);
        this.id = id;
    }

    @Override
    public boolean isNew() {
        return ElementLifeCycle.isNew(this.it().getLifeCycle());
    }

    @Override
    public boolean isLoaded() {
        return ElementLifeCycle.isLoaded(this.it().getLifeCycle());
    }

    @Override
    public boolean isRemoved() {
        return ElementLifeCycle.isRemoved(this.it().getLifeCycle());
    }
}

