/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.internal;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class OrderList
implements Comparator<TitanElement> {
    public static final OrderList NO_ORDER = new OrderList(){
        {
            this.makeImmutable();
        }
    };
    private List<OrderEntry> list = new ArrayList<OrderEntry>(3);
    private boolean immutable = false;

    public void add(TitanKey key, Order order) {
        Preconditions.checkArgument((!this.immutable ? 1 : 0) != 0, (Object)"This OrderList has been closed");
        this.list.add(new OrderEntry(key, order));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public TitanKey getKey(int position) {
        return this.list.get(position).getKey();
    }

    public Order getOrder(int position) {
        return this.list.get(position).getOrder();
    }

    public int size() {
        return this.list.size();
    }

    public boolean containsKey(String key) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.getKey(i).equals(key)) continue;
            return true;
        }
        return false;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public String toString() {
        return this.list.toString();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        return this.list.equals(((OrderList)oth).list);
    }

    @Override
    public int compare(TitanElement o1, TitanElement o2) {
        for (int i = 0; i < this.list.size(); ++i) {
            int cmp = this.list.get(i).compare(o1, o2);
            if (cmp == 0) continue;
            return cmp;
        }
        return o1.compareTo(o2);
    }

    public static class OrderEntry
    implements Comparator<TitanElement> {
        private final TitanKey key;
        private final Order order;

        public OrderEntry(TitanKey key, Order order) {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)((Object)order));
            this.key = key;
            this.order = order;
        }

        public TitanKey getKey() {
            return this.key;
        }

        public Order getOrder() {
            return this.order;
        }

        public int hashCode() {
            return this.key.hashCode() * 1003 + this.order.hashCode();
        }

        @Override
        public int compare(TitanElement o1, TitanElement o2) {
            Object v1 = o1.getProperty(this.key);
            Object v2 = o2.getProperty(this.key);
            if (v1 == null || v2 == null) {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                return -1;
            }
            return this.order.modulateNaturalOrder(((Comparable)v1).compareTo(v2));
        }

        @Override
        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null) {
                return false;
            }
            if (!this.getClass().isInstance(oth)) {
                return false;
            }
            OrderEntry o = (OrderEntry)oth;
            return this.key.equals(o.key) && this.order == o.order;
        }

        public String toString() {
            return (Object)((Object)this.order) + "(" + this.key + ")";
        }
    }
}

