/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.FixedCondition;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.List;

class BaseVertexCentricQuery
extends BaseQuery {
    protected final Condition<TitanRelation> condition;
    protected final List<BackendQueryHolder<SliceQuery>> queries;
    protected final Direction direction;

    public BaseVertexCentricQuery(Condition<TitanRelation> condition, Direction direction, List<BackendQueryHolder<SliceQuery>> queries, int limit) {
        super(limit);
        Preconditions.checkNotNull(condition);
        Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(condition));
        Preconditions.checkNotNull(queries);
        Preconditions.checkNotNull((Object)direction);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        this.condition = condition;
        this.queries = queries;
        this.direction = direction;
    }

    protected BaseVertexCentricQuery(BaseVertexCentricQuery query) {
        this(query.getCondition(), query.getDirection(), query.getQueries(), query.getLimit());
    }

    protected BaseVertexCentricQuery() {
        this(new FixedCondition<TitanRelation>(false), Direction.BOTH, new ArrayList<BackendQueryHolder<SliceQuery>>(0), 0);
    }

    public static BaseVertexCentricQuery emptyQuery() {
        return new BaseVertexCentricQuery();
    }

    public Condition<TitanRelation> getCondition() {
        return this.condition;
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected List<BackendQueryHolder<SliceQuery>> getQueries() {
        return this.queries;
    }

    public boolean isEmpty() {
        return this.getLimit() <= 0;
    }

    public int numSubQueries() {
        return this.queries.size();
    }

    public BackendQueryHolder<SliceQuery> getSubQuery(int position) {
        return this.queries.get(position);
    }

    public boolean matches(TitanRelation relation) {
        return this.condition.evaluate(relation);
    }

    public String toString() {
        String s = "[" + this.condition.toString() + "]";
        if (this.hasLimit()) {
            s = s + ":" + this.getLimit();
        }
        return s;
    }
}

