/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.thinkaurelius.titan.core.QueryException;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.graphdb.query.BackendQuery;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.ElementQuery;
import com.thinkaurelius.titan.graphdb.query.QueryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor<Q extends ElementQuery<R, B>, R extends TitanElement, B extends BackendQuery<B>>
implements Iterable<R> {
    private static final Logger log = LoggerFactory.getLogger(QueryProcessor.class);
    private static final int MAX_SORT_ITERATION = 1000000;
    private final Q query;
    private final QueryExecutor<Q, R, B> executor;

    public QueryProcessor(Q query, QueryExecutor<Q, R, B> executor) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(executor);
        this.query = query;
        this.executor = executor;
    }

    @Override
    public Iterator<R> iterator() {
        if (this.query.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new OuterIterator();
    }

    private Iterator<R> getUnwrappedIterator() {
        UnmodifiableIterator iter = null;
        boolean hasDeletions = this.executor.hasDeletions(this.query);
        Iterator<R> newElements = this.executor.getNew(this.query);
        if (this.query.isSorted()) {
            for (int i = this.query.numSubQueries() - 1; i >= 0; --i) {
                BackendQueryHolder subq = this.query.getSubQuery(i);
                MergeSortIterator subqiter = this.getFilterIterator(subq.isSorted() ? new LimitAdjustingIterator(subq) : new PreSortingIterator(subq), hasDeletions, !subq.isFitted());
                iter = iter == null ? subqiter : new MergeSortIterator(subqiter, iter, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
            Preconditions.checkArgument((iter != null ? 1 : 0) != 0);
            if (newElements.hasNext()) {
                ArrayList allNew = Lists.newArrayList(newElements);
                Collections.sort(allNew, this.query.getSortOrder());
                iter = new MergeSortIterator(allNew.iterator(), iter, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
        } else {
            final HashSet allNew = newElements.hasNext() ? Sets.newHashSet(newElements) : ImmutableSet.of();
            ArrayList<LimitAdjustingIterator> iters = new ArrayList<LimitAdjustingIterator>(this.query.numSubQueries());
            for (int i = 0; i < this.query.numSubQueries(); ++i) {
                BackendQueryHolder subq = this.query.getSubQuery(i);
                Iterator subiter = new LimitAdjustingIterator(subq);
                subiter = this.getFilterIterator(subiter, hasDeletions, !subq.isFitted());
                if (!allNew.isEmpty()) {
                    subiter = Iterators.filter((Iterator)subiter, (Predicate)new Predicate<R>(){

                        public boolean apply(@Nullable R r) {
                            return !allNew.contains(r);
                        }
                    });
                }
                iters.add((LimitAdjustingIterator)subiter);
            }
            if (iters.size() > 1) {
                iter = Iterators.concat(iters.iterator());
                if (this.query.hasDuplicateResults()) {
                    final HashSet seenResults = new HashSet();
                    iter = Iterators.filter(iter, (Predicate)new Predicate<R>(){

                        public boolean apply(@Nullable R r) {
                            if (seenResults.contains(r)) {
                                return false;
                            }
                            seenResults.add(r);
                            return true;
                        }
                    });
                }
            } else {
                iter = (Iterator)iters.get(0);
            }
            if (!allNew.isEmpty()) {
                iter = Iterators.concat(allNew.iterator(), (Iterator)iter);
            }
        }
        return iter;
    }

    private Iterator<R> getFilterIterator(Iterator<R> iter, final boolean filterDeletions, final boolean filterMatches) {
        if (filterDeletions || filterMatches) {
            return Iterators.filter(iter, (Predicate)new Predicate<R>(){

                public boolean apply(@Nullable R r) {
                    return !(filterDeletions && QueryProcessor.this.executor.isDeleted(QueryProcessor.this.query, r) || filterMatches && !QueryProcessor.this.query.matches(r));
                }
            });
        }
        return iter;
    }

    private static final class MergeSortIterator<R>
    implements Iterator<R> {
        private final Iterator<R> first;
        private final Iterator<R> second;
        private final Comparator<R> comp;
        private final boolean filterDuplicates;
        private R nextFirst;
        private R nextSecond;
        private R next;

        public MergeSortIterator(Iterator<R> first, Iterator<R> second, Comparator<R> comparator, boolean filterDuplicates) {
            Preconditions.checkNotNull(first);
            Preconditions.checkNotNull(second);
            Preconditions.checkNotNull(comparator);
            this.first = first;
            this.second = second;
            this.comp = comparator;
            this.filterDuplicates = filterDuplicates;
            this.nextFirst = null;
            this.nextSecond = null;
            this.next = this.nextInternal();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            R current = this.next;
            this.next = null;
            do {
                this.next = this.nextInternal();
            } while (this.next != null && this.filterDuplicates && this.comp.compare(current, this.next) == 0);
            return current;
        }

        public R nextInternal() {
            if (this.nextFirst == null && this.first.hasNext()) {
                this.nextFirst = this.first.next();
                assert (this.nextFirst != null);
            }
            if (this.nextSecond == null && this.second.hasNext()) {
                this.nextSecond = this.second.next();
                assert (this.nextSecond != null);
            }
            R result = null;
            if (this.nextFirst == null && this.nextSecond == null) {
                return null;
            }
            if (this.nextFirst == null) {
                result = this.nextSecond;
                this.nextSecond = null;
            } else if (this.nextSecond == null) {
                result = this.nextFirst;
                this.nextFirst = null;
            } else {
                int c = this.comp.compare(this.nextFirst, this.nextSecond);
                if (c <= 0) {
                    result = this.nextFirst;
                    this.nextFirst = null;
                } else {
                    result = this.nextSecond;
                    this.nextSecond = null;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class LimitAdjustingIterator
    extends com.thinkaurelius.titan.graphdb.query.LimitAdjustingIterator<R> {
        private B backendQuery;
        private final Object executionInfo;

        private LimitAdjustingIterator(BackendQueryHolder<B> backendQueryHolder) {
            super(0x7FFFFFFE, backendQueryHolder.getBackendQuery().getLimit());
            this.backendQuery = backendQueryHolder.getBackendQuery();
            this.executionInfo = backendQueryHolder.getExecutionInfo();
        }

        @Override
        public Iterator<R> getNewIterator(int newLimit) {
            if (!this.backendQuery.hasLimit() || newLimit > this.backendQuery.getLimit()) {
                this.backendQuery = this.backendQuery.updateLimit(newLimit);
            }
            return QueryProcessor.this.executor.execute(QueryProcessor.this.query, this.backendQuery, this.executionInfo);
        }
    }

    private final class PreSortingIterator
    implements Iterator<R> {
        private final Iterator<R> iter;

        private PreSortingIterator(BackendQueryHolder<B> backendQueryHolder) {
            ArrayList all = Lists.newArrayList(QueryProcessor.this.executor.execute(QueryProcessor.this.query, backendQueryHolder.getBackendQuery().updateLimit(1000000), backendQueryHolder.getExecutionInfo()));
            if (all.size() >= 1000000) {
                throw new QueryException("Could not execute query since pre-sorting requires fetching more than 1000000 elements. Consider rewriting the query to exploit sort orders");
            }
            Collections.sort(all, QueryProcessor.this.query.getSortOrder());
            this.iter = all.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public R next() {
            return (TitanElement)this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class OuterIterator
    implements Iterator<R> {
        private final Iterator<R> iter;
        private final int limit;
        private R current;
        private R next;
        private int count;

        OuterIterator() {
            this.iter = QueryProcessor.this.getUnwrappedIterator();
            this.limit = QueryProcessor.this.query.hasLimit() ? QueryProcessor.this.query.getLimit() : Integer.MAX_VALUE;
            this.count = 0;
            this.current = null;
            this.next = this.nextInternal();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private R nextInternal() {
            TitanElement r = null;
            if (this.count < this.limit && this.iter.hasNext()) {
                r = (TitanElement)this.iter.next();
            }
            return r;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            ++this.count;
            this.next = this.nextInternal();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new UnsupportedOperationException();
            }
            this.current.remove();
        }
    }
}

