/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import cern.colt.list.AbstractLongList;
import cern.colt.list.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanKey;
import com.thinkaurelius.titan.core.TitanLabel;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.Entry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.RelationQueryCache;
import com.thinkaurelius.titan.graphdb.internal.InternalType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationType;
import com.thinkaurelius.titan.graphdb.query.AbstractVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.VertexLongList;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVertexQueryProcessor
implements Iterable<Entry> {
    private static final Logger log = LoggerFactory.getLogger(SimpleVertexQueryProcessor.class);
    private static final int INITIAL_QUERY_LIMIT = 10000;
    private final InternalVertex vertex;
    private final StandardTitanTx tx;
    private final EdgeSerializer edgeSerializer;
    private SliceQuery sliceQuery;
    private int limit = Integer.MAX_VALUE;
    private Direction filterDirection;
    private TitanKey key;
    private boolean filterHiddenProperties;

    private SimpleVertexQueryProcessor(InternalVertex vertex) {
        Preconditions.checkArgument((boolean)vertex.isLoaded(), (Object)"SimpleVertexQuery only applies to unmodified vertices");
        this.vertex = vertex;
        this.tx = vertex.tx();
        this.edgeSerializer = this.tx.getEdgeSerializer();
    }

    public SimpleVertexQueryProcessor(InternalVertex vertex, TitanKey key) {
        this(vertex);
        assert (key == null || !((InternalType)((Object)key)).isHidden());
        assert (key == null || !((InternalType)((Object)key)).isStatic(Direction.OUT));
        RelationQueryCache cache = this.tx.getGraph().getRelationCache();
        boolean bl = this.filterHiddenProperties = key == null;
        if (key == null || this.tx.getConfiguration().hasPropertyPrefetching()) {
            this.key = key;
            this.sliceQuery = cache.getQuery(RelationType.PROPERTY);
        } else {
            this.sliceQuery = cache.getQuery((InternalType)((Object)key), Direction.OUT);
        }
    }

    public SimpleVertexQueryProcessor(InternalVertex vertex, Direction dir, TitanLabel label, EdgeSerializer.TypedInterval[] sortKeyConstraints, int limit) {
        this(vertex);
        Preconditions.checkNotNull((Object)dir);
        RelationQueryCache cache = this.tx.getGraph().getRelationCache();
        if (label == null) {
            assert (sortKeyConstraints == null);
            this.sliceQuery = cache.getQuery(RelationType.EDGE);
            this.filterDirection = dir == Direction.BOTH ? null : dir;
        } else {
            this.sliceQuery = AbstractVertexCentricQueryBuilder.hasSortKeyConstraints(sortKeyConstraints) ? this.edgeSerializer.getQuery((InternalType)((Object)label), dir, sortKeyConstraints, null) : cache.getQuery((InternalType)((Object)label), dir);
            this.filterDirection = null;
        }
        this.limit = limit;
        if (limit != Integer.MAX_VALUE) {
            this.sliceQuery = this.sliceQuery.updateLimit(limit);
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        LimitAdjustingIterator iter = this.sliceQuery.hasLimit() && this.sliceQuery.getLimit() != this.limit ? new LimitAdjustingIterator() : this.getBasicIterator();
        if (this.filterDirection != null) {
            assert (this.filterDirection != Direction.BOTH);
            iter = Iterators.filter((Iterator)iter, (Predicate)new Predicate<Entry>(){

                public boolean apply(@Nullable Entry entry) {
                    return SimpleVertexQueryProcessor.this.edgeSerializer.parseDirection(entry) == SimpleVertexQueryProcessor.this.filterDirection;
                }
            });
        }
        return iter;
    }

    public Iterable<TitanRelation> relations() {
        return Iterables.transform((Iterable)this, (Function)new Function<Entry, TitanRelation>(){

            @Nullable
            public TitanRelation apply(@Nullable Entry entry) {
                return SimpleVertexQueryProcessor.this.edgeSerializer.readRelation(SimpleVertexQueryProcessor.this.vertex, entry);
            }
        });
    }

    public Iterable<TitanEdge> titanEdges() {
        return this.relations();
    }

    public Iterable<TitanProperty> properties() {
        Iterable result = this.relations();
        if (this.filterHiddenProperties || this.key != null) {
            result = Iterables.filter(result, (Predicate)new Predicate<TitanProperty>(){

                public boolean apply(@Nullable TitanProperty titanProperty) {
                    return !(SimpleVertexQueryProcessor.this.filterHiddenProperties && ((InternalType)((Object)titanProperty.getPropertyKey())).isHidden() || SimpleVertexQueryProcessor.this.key != null && !titanProperty.getPropertyKey().equals(SimpleVertexQueryProcessor.this.key));
                }
            });
        }
        return result;
    }

    public Iterable<Edge> edges() {
        return this.relations();
    }

    public Iterable<Vertex> vertices() {
        return Iterables.transform((Iterable)this, (Function)new Function<Entry, Vertex>(){

            @Nullable
            public Vertex apply(@Nullable Entry entry) {
                return SimpleVertexQueryProcessor.this.tx.getExistingVertex(SimpleVertexQueryProcessor.this.edgeSerializer.readRelation(SimpleVertexQueryProcessor.this.vertex.getID(), entry, true, SimpleVertexQueryProcessor.this.tx).getOtherVertexId());
            }
        });
    }

    public VertexList vertexIds() {
        LongArrayList list = new LongArrayList();
        for (Long id : Iterables.transform((Iterable)this, (Function)new Function<Entry, Long>(){

            @Nullable
            public Long apply(@Nullable Entry entry) {
                return SimpleVertexQueryProcessor.this.edgeSerializer.readRelation(SimpleVertexQueryProcessor.this.vertex.getID(), entry, true, SimpleVertexQueryProcessor.this.tx).getOtherVertexId();
            }
        })) {
            list.add(id.longValue());
        }
        return new VertexLongList(this.tx, (AbstractLongList)list);
    }

    private Iterator<Entry> getBasicIterator() {
        return this.vertex.loadRelations(this.sliceQuery, new Retriever<SliceQuery, List<Entry>>(){

            @Override
            public List<Entry> get(SliceQuery query) {
                return SimpleVertexQueryProcessor.this.tx.getGraph().edgeQuery(SimpleVertexQueryProcessor.this.vertex.getID(), query, SimpleVertexQueryProcessor.this.tx.getTxHandle());
            }
        }).iterator();
    }

    private final class LimitAdjustingIterator
    extends com.thinkaurelius.titan.graphdb.query.LimitAdjustingIterator<Entry> {
        private LimitAdjustingIterator() {
            super(SimpleVertexQueryProcessor.this.limit, SimpleVertexQueryProcessor.this.sliceQuery.getLimit());
        }

        @Override
        public Iterator<Entry> getNewIterator(int newLimit) {
            if (newLimit > SimpleVertexQueryProcessor.this.sliceQuery.getLimit()) {
                SimpleVertexQueryProcessor.this.sliceQuery = SimpleVertexQueryProcessor.this.sliceQuery.updateLimit(newLimit);
            }
            return SimpleVertexQueryProcessor.this.getBasicIterator();
        }
    }
}

