/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import cern.colt.list.AbstractLongList;
import cern.colt.list.LongArrayList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.graphdb.query.VertexListInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VertexArrayList
implements VertexListInternal {
    private final ArrayList<TitanVertex> vertices = new ArrayList();
    private boolean sorted = false;

    @Override
    public void add(TitanVertex n) {
        this.vertices.add(n);
    }

    @Override
    public long getID(int pos) {
        return this.vertices.get(pos).getID();
    }

    @Override
    public AbstractLongList getIDs() {
        return VertexArrayList.toLongList(this.vertices);
    }

    @Override
    public TitanVertex get(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        Collections.sort(this.vertices);
        this.sorted = true;
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        Preconditions.checkArgument((boolean)(vertexlist instanceof VertexArrayList), (Object)"Only supporting union of identical lists.");
        VertexArrayList other = (VertexArrayList)vertexlist;
        this.sorted = false;
        this.vertices.addAll(other.vertices);
    }

    @Override
    public Iterator<TitanVertex> iterator() {
        return Iterators.unmodifiableIterator(this.vertices.iterator());
    }

    private static final AbstractLongList toLongList(List<TitanVertex> vertices) {
        LongArrayList result = new LongArrayList(vertices.size());
        for (TitanVertex n : vertices) {
            result.add(n.getID());
        }
        return result;
    }
}

